/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.service;

import br.com.argus.cronos.exception.ConfiguracaoException;
import br.com.argus.cronos.exception.ConnectionException;
import br.com.argus.cronos.gui.TelaPrincipal;
import br.com.argus.cronos.gui.TipoIconeStatus;
import br.com.argus.cronos.gui.ViewService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.service.ImpressaoService;
import javax.swing.ImageIcon;

public class ThreadService
implements Runnable {
    private final int TIME = 2;
    private static Thread thread;
    private static ThreadService threadService;
    private boolean continuar = true;
    private boolean forcarConsulta = false;
    private static final String PLAY_ICON = "/play.png";
    private static final String PAUSE_ICON = "/pause.png";

    public static void iniciarVerificacao() {
        TelaPrincipal tela = ViewService.getTelaPrincipal();
        tela.getPlayAndPauseButton().setIcon(new ImageIcon(ThreadService.class.getResource(PAUSE_ICON)));
        ViewService.setStatus("Verifica\u00e7\u00e3o iniciada", TipoIconeStatus.LOAD);
        threadService = new ThreadService();
        ThreadService.threadService.continuar = true;
        thread = new Thread(threadService);
        thread.start();
        ViewService.setBuscarDocumentosEnabled(true);
        ViewService.setStatus("Verifica\u00e7\u00e3o iniciada", TipoIconeStatus.WAIT);
        ViewService.printResponseArea("Verifica\u00e7\u00e3o iniciada.", TipoMensagem.INFO);
    }

    public static void pararVerificacao() {
        TelaPrincipal tela = ViewService.getTelaPrincipal();
        tela.getPlayAndPauseButton().setIcon(new ImageIcon(ThreadService.class.getResource(PLAY_ICON)));
        ThreadService.threadService.continuar = false;
        ViewService.setBuscarDocumentosEnabled(false);
        ViewService.setStatus("Verifica\u00e7\u00e3o interrompida", TipoIconeStatus.STOP);
        ViewService.printResponseArea("Verifica\u00e7\u00e3o interrompida.", TipoMensagem.INFO);
    }

    public static void forcarConsulta(boolean systemTray) {
        if (threadService != null) {
            ThreadService.threadService.forcarConsulta = true;
        }
    }

    public static boolean isAtivo() {
        return threadService == null ? false : ThreadService.threadService.continuar;
    }

    @Override
    public void run() {
        try {
            block12: while (this.continuar) {
                for (int i = 2; i >= 0; --i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        ViewService.printResponseArea("Erro de Interrup\u00e7\u00e3o.", TipoMensagem.ERROR, e);
                        ViewService.showTrayMessage("Erro de Interrup\u00e7\u00e3o.", TipoMensagem.ERROR);
                        this.continuar = false;
                        continue block12;
                    }
                    if (this.forcarConsulta) {
                        i = 0;
                    }
                    if (i == 0) {
                        ImpressaoService.verificarPendencias(this.forcarConsulta);
                        this.forcarConsulta = false;
                    }
                    if (!this.continuar) {
                        i = 0;
                    }
                    if (i == 0) continue;
                    ViewService.setStatus("Pr\u00f3xima consulta em " + i + " segundo(s).", TipoIconeStatus.WAIT);
                }
            }
        }
        catch (ConfiguracaoException e) {
            String mensagem = "";
            String status = "Erro de configura\u00e7\u00f5es.";
            switch (e.motivo) {
                case ERRO_AO_GRAVAR_ARQUIVO: {
                    mensagem = "Erro ao gravar no arquivo de configura\u00e7\u00f5es.";
                    break;
                }
                case ERRO_AO_LER_ARQUIVO_CONFIGURACAO: {
                    mensagem = "Erro ao ler o arquivo de configura\u00e7\u00f5es.";
                    break;
                }
                case FALTA_CONFIGURACAO: {
                    mensagem = "O sistema n\u00e3o possui configura\u00e7\u00f5es.";
                    break;
                }
                case USUARIO_SENHA_INCORRETOS: {
                    mensagem = "Usu\u00e1rio e senha configurados est\u00e3o incorretos.";
                }
            }
            ViewService.printResponseArea(mensagem, TipoMensagem.ERROR, e);
            ViewService.setStatus(status, TipoIconeStatus.STOP);
            ViewService.showTrayMessage(mensagem, TipoMensagem.ERROR);
            ThreadService.pararVerificacao();
        }
        catch (ConnectionException e) {
            ViewService.printResponseArea("Erro de conex\u00e3o. Causa: " + e.getMessage(), TipoMensagem.ERROR, e);
            ViewService.setStatus("Erro de conex\u00e3o.", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro de conex\u00e3o. Causa: " + e.getMessage(), TipoMensagem.ERROR);
            ThreadService.pararVerificacao();
        }
        catch (Exception e) {
            ViewService.printResponseArea("Erro desconhecido. Causa: " + e.getMessage(), TipoMensagem.ERROR, e);
            ViewService.setStatus("Erro desconhecido.", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro desconhecido. " + e.getMessage(), TipoMensagem.ERROR);
            ThreadService.pararVerificacao();
        }
    }
}

