/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.service;

import br.com.argus.cronos.comunicacao.ConexaoService;
import br.com.argus.cronos.comunicacao.RespostaHTTP;
import br.com.argus.cronos.config.ConfiguracaoDTO;
import br.com.argus.cronos.config.ConfiguracaoEnum;
import br.com.argus.cronos.config.ConfigurationService;
import br.com.argus.cronos.config.DefinicaoImpressoraDTO;
import br.com.argus.cronos.dto.ImpressaoDTO;
import br.com.argus.cronos.exception.ConfiguracaoException;
import br.com.argus.cronos.exception.ConfiguracaoExceptionEnum;
import br.com.argus.cronos.exception.ConnectionException;
import br.com.argus.cronos.gui.TelaPrincipal;
import br.com.argus.cronos.gui.TipoIconeStatus;
import br.com.argus.cronos.gui.ViewService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.service.ThreadService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

public class ImpressaoService {
    public static void carregarListaImpressoras() {
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        telaPrincipal.getComboBoxImpressoras().removeAllItems();
        telaPrincipal.getLabelStatusImpressoras().setText("Carregando...");
        ArrayList<String> listaImpressora = ImpressaoService.getListaImpressoras();
        if (listaImpressora.isEmpty()) {
            telaPrincipal.getLabelStatusImpressoras().setText("Nenhuma impressora encontrada.");
        } else {
            for (String imp : listaImpressora) {
                telaPrincipal.getComboBoxImpressoras().addItem(imp);
            }
            telaPrincipal.getLabelStatusImpressoras().setText("");
        }
    }

    public static void imprimirDocumentoConsultado(String nomeImpressora, byte[] arquivo) {
        try {
            PDDocument document = PDDocument.load((byte[])arquivo);
            ImpressaoService.imprimir(document, nomeImpressora);
        }
        catch (IOException ex) {
            ViewService.printResponseArea("Erro ao tentar imprimir na impressora: " + nomeImpressora + ". Causa: " + ex.getMessage(), TipoMensagem.ERROR, ex);
            ViewService.setStatus("Erro ao tentar imprimir", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro ao tentar imprimir. Causa: " + ex.getMessage(), TipoMensagem.ERROR);
        }
    }

    public static void imprimirPaginaTeste(String nomeImpressora) throws IOException, PrinterException, URISyntaxException {
        File file = new File(System.getProperty("user.dir") + "\\teste\\PaginaTeste.pdf");
        PDDocument document = PDDocument.load((File)file);
        ImpressaoService.imprimir(document, nomeImpressora);
    }

    private static void imprimir(PDDocument document, String nomeImpressora) {
        try {
            ConfiguracaoEnum.TipoLarguraPapelEnum tipoLargura;
            ConfiguracaoEnum.TipoAlturaPapelEnum tipoAltura;
            ConfiguracaoEnum.ModeloPaginaEnum modeloPagina;
            PDFPageable pdfPage = new PDFPageable(document);
            PrintService impressoraService = ImpressaoService.getPrintService(nomeImpressora);
            PrinterJob impressao = PrinterJob.getPrinterJob();
            impressao.setPrintService(impressoraService);
            DefinicaoImpressoraDTO config = ConfigurationService.getImpressoraDTO(nomeImpressora);
            try {
                modeloPagina = ConfiguracaoEnum.ModeloPaginaEnum.getEnum(config.getModeloPagina().trim());
            }
            catch (NullPointerException e) {
                modeloPagina = null;
            }
            try {
                tipoAltura = ConfiguracaoEnum.TipoAlturaPapelEnum.getEnum(config.getTipoAlturaPapel().trim());
            }
            catch (NullPointerException e) {
                tipoAltura = ConfiguracaoEnum.TipoAlturaPapelEnum.IMPRESSORA;
            }
            try {
                tipoLargura = ConfiguracaoEnum.TipoLarguraPapelEnum.getEnum(config.getTipoLarguraPapel().trim());
            }
            catch (NullPointerException e) {
                tipoLargura = ConfiguracaoEnum.TipoLarguraPapelEnum.PDF;
            }
            switch (modeloPagina) {
                case IMPRESSORA: {
                    PageFormat format = impressao.defaultPage();
                    impressao.setPrintable(pdfPage.getPrintable(0), format);
                    break;
                }
                case PDF_DEFAULT: {
                    impressao.setPrintable(pdfPage.getPrintable(0), pdfPage.getPageFormat(0));
                    break;
                }
                default: {
                    Double larguraPagina;
                    Double alturaPagina;
                    PageFormat format = pdfPage.getPageFormat(0);
                    Paper paper = format.getPaper();
                    try {
                        paper.setImageableArea(config.getAlinhamentoX(), config.getAlinhamentoY(), paper.getImageableWidth(), paper.getImageableHeight());
                    }
                    catch (NullPointerException e) {
                        paper.setImageableArea(0.0, 0.0, paper.getImageableWidth(), paper.getImageableHeight());
                    }
                    switch (tipoAltura) {
                        case IMPRESSORA: {
                            alturaPagina = impressao.getPageFormat(null).getHeight();
                            break;
                        }
                        case PDF: {
                            alturaPagina = paper.getHeight();
                            break;
                        }
                        default: {
                            alturaPagina = impressao.getPageFormat(null).getHeight();
                        }
                    }
                    switch (tipoLargura) {
                        case IMPRESSORA: {
                            larguraPagina = impressao.getPageFormat(null).getWidth();
                            break;
                        }
                        case PDF: {
                            larguraPagina = paper.getWidth();
                            break;
                        }
                        default: {
                            larguraPagina = paper.getWidth();
                        }
                    }
                    paper.setSize(larguraPagina, alturaPagina);
                    format.setPaper(paper);
                    impressao.setPrintable(pdfPage.getPrintable(0), format);
                }
            }
            impressao.print();
            document.close();
        }
        catch (PrinterException | IOException ex) {
            ViewService.printResponseArea("Erro ao tentar imprimir na impressora: " + nomeImpressora + ". Causa: " + ex.getMessage(), TipoMensagem.ERROR, ex);
            ViewService.setStatus("Erro ao tentar imprimir", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro ao tentar imprimir. Causa: " + ex.getMessage(), TipoMensagem.ERROR);
        }
    }

    private static PrintService getPrintService(String printerName) {
        PrintService[] printServices;
        for (PrintService printService : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
            if (!printService.getName().trim().equals(printerName)) continue;
            return printService;
        }
        return null;
    }

    private static ArrayList<String> getListaImpressoras() {
        PrintService[] printServices;
        ArrayList<String> listaImpressora = new ArrayList<String>();
        for (PrintService printService : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
            listaImpressora.add(printService.getName().trim());
        }
        return listaImpressora;
    }

    public static void verificarPendencias(boolean forcada) {
        try {
            ViewService.setStatus("Consultando documentos.", TipoIconeStatus.LOAD);
            RespostaHTTP resposta = ConexaoService.verificarPendencias(forcada);
            switch (resposta.getStatus()) {
                case 200: {
                    ViewService.setStatus("Documentos encontradados.", TipoIconeStatus.LOAD);
                    Gson gson = new GsonBuilder().create();
                    List listaImpressao = (List)gson.fromJson(resposta.getResponse(), new TypeToken<List<ImpressaoDTO>>(){}.getType());
                    ConfiguracaoDTO config = ConfigurationService.getConfiguration();
                    for (ImpressaoDTO impressaoDTO : listaImpressao) {
                        System.out.println("---------- IMPRESSOES ----------");
                        System.out.println("idPedido: " + impressaoDTO.getIdPedido());
                        System.out.println("id: " + impressaoDTO.getId());
                        System.out.println("nome: " + impressaoDTO.getNome());
                        System.out.println("uuid: " + impressaoDTO.getUuidAuxiliar());
                        System.out.println("--------------------------------");
                        if (impressaoDTO.getUuidAuxiliar() == null || !impressaoDTO.getUuidAuxiliar().equals(config.getUuidAuxiliar())) continue;
                        ViewService.setStatus("Imprimindo.", TipoIconeStatus.PRINTING);
                        byte[] arquivo = ConexaoService.consultarArquivos(impressaoDTO.getId() != null ? impressaoDTO.getId() : impressaoDTO.getIdPedido(), impressaoDTO.getIdImpressora(), impressaoDTO.getUrlPath());
                        ImpressaoService.imprimirDocumentoConsultado(impressaoDTO.getNome(), arquivo);
                    }
                    break;
                }
                case 403: {
                    throw new ConfiguracaoException("Erro 403. UUID n\u00e3o encontrado.", ConfiguracaoExceptionEnum.UUID_NAO_UTILIZADA);
                }
                default: {
                    ViewService.setStatus("Nenhum documento encontrado.", TipoIconeStatus.EMPTY);
                    if (forcada) {
                        ViewService.showTrayMessage("Nenhum documento encontrado.", TipoMensagem.INFO);
                    }
                }
            }
        }
        catch (ConnectionException e) {
            ViewService.setStatus("Falha ao conectar com o servidor.", TipoIconeStatus.STOP);
            ViewService.printResponseArea("Falha ao conectar com o servidor. Preparando para novas tentativas.", TipoMensagem.WARNING, e);
            if (forcada) {
                ViewService.showTrayMessage("Falha ao conectar com o servidor. Preparando para novas tentativas.", TipoMensagem.ERROR);
            }
        }
        catch (ConfiguracaoException e) {
            String mensagem = "";
            String status = "Erro de configura\u00e7\u00f5es.";
            switch (e.motivo) {
                case ERRO_AO_GRAVAR_ARQUIVO: {
                    mensagem = "Erro ao gravar no arquivo de configura\u00e7\u00f5es.";
                    break;
                }
                case ERRO_AO_LER_ARQUIVO_CONFIGURACAO: {
                    mensagem = "Erro ao ler o arquivo de configura\u00e7\u00f5es.";
                    break;
                }
                case FALTA_CONFIGURACAO: {
                    mensagem = "O sistema n\u00e3o possui configura\u00e7\u00f5es.";
                    break;
                }
                case USUARIO_SENHA_INCORRETOS: {
                    mensagem = "Usu\u00e1rio e senha configurados est\u00e3o incorretos.";
                    break;
                }
                case UUID_NAO_UTILIZADA: {
                    mensagem = "UUID deste auxiliar n\u00e3o est\u00e1 sendo utilizado.";
                }
            }
            ViewService.printResponseArea(mensagem, TipoMensagem.ERROR, e);
            ViewService.setStatus(status, TipoIconeStatus.STOP);
            ViewService.showTrayMessage(mensagem, TipoMensagem.ERROR);
            ThreadService.pararVerificacao();
        }
        catch (Exception e) {
            ViewService.printResponseArea("Erro desconhecido. Causa: " + e.getMessage(), TipoMensagem.ERROR, e);
            ViewService.setStatus("Erro desconhecido.", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro desconhecido. " + e.getMessage(), TipoMensagem.ERROR);
        }
    }
}

