/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.comunicacao;

import br.com.argus.cronos.comunicacao.HTTPURLConnection;
import br.com.argus.cronos.comunicacao.RespostaHTTP;
import br.com.argus.cronos.config.ConfiguracaoDTO;
import br.com.argus.cronos.config.ConfiguracaoEnum;
import br.com.argus.cronos.config.ConfigurationService;
import br.com.argus.cronos.exception.ConfiguracaoException;
import br.com.argus.cronos.exception.ConfiguracaoExceptionEnum;
import br.com.argus.cronos.exception.ConnectionException;
import br.com.argus.cronos.exception.PreCondicaoException;
import org.json.JSONException;
import org.json.JSONObject;

public class ConexaoService {
    private static final int UNAUTHORIZED = 401;
    private static final int LOGIN_TIMEOUT = 440;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int PRE_CONDITION_FAILED = 412;
    private static final int SUCCESS = 200;
    private static final String PATH_AUTORIZAR = "/api/logar";
    private static final String PATH_RETORNO = "/api/pendencia/enviar";
    private static String token = "";

    public static void zerarToken() {
        token = "";
    }

    public static RespostaHTTP verificarPendencias(boolean forcada) throws ConfiguracaoException {
        HTTPURLConnection http = new HTTPURLConnection();
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        String url = config.getUrlSoftware() + config.getUrlVerificacao();
        RespostaHTTP resposta = http.get(url).addParam("verificacaoForcada", forcada + "").addParam("uuidAuxiliar", config.getUuidAuxiliar()).addHeader("Authorization", token).startRequest();
        if (ConexaoService.isAutorizado(resposta.getStatus())) {
            ConexaoService.checkResponse(resposta, url);
            return resposta;
        }
        ConexaoService.autorizar(config);
        return ConexaoService.verificarPendencias(forcada);
    }

    public static byte[] consultarArquivos(Integer id, Integer idImpressora, String urlPath) throws ConfiguracaoException {
        RespostaHTTP resposta;
        ConfiguracaoEnum.SistemaEnum sistema;
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        HTTPURLConnection http = new HTTPURLConnection();
        try {
            sistema = ConfiguracaoEnum.SistemaEnum.getEnum(config.getSistema());
            if (sistema == null) {
                throw new ConfiguracaoException("Selecione o sistema utilizado.", ConfiguracaoExceptionEnum.SELECIONAR_SISTEMA);
            }
        }
        catch (NullPointerException e) {
            throw new ConfiguracaoException("Configure o sistema antes do uso.", ConfiguracaoExceptionEnum.FALTA_CONFIGURACAO);
        }
        String url = config.getUrlSoftware() + urlPath;
        switch (sistema) {
            case ARGUS_CHEF: {
                resposta = http.get(url).addParam("idPedido", id + "").addParam("idImpressora", idImpressora + "").addParam("mobile", "false").addParam("uuidAuxiliar", config.getUuidAuxiliar()).addHeader("Authorization", token).startRequestFile();
                break;
            }
            default: {
                resposta = http.get(url).addParam("id", id + "").addParam("idImpressora", idImpressora + "").addParam("mobile", "false").addParam("uuidAuxiliar", config.getUuidAuxiliar()).addHeader("Authorization", token).startRequestFile();
            }
        }
        if (ConexaoService.isAutorizado(resposta.getStatus())) {
            ConexaoService.checkResponse(resposta, url);
            return resposta.getArquivo();
        }
        ConexaoService.autorizar(config);
        return ConexaoService.consultarArquivos(id, idImpressora, urlPath);
    }

    private static boolean isAutorizado(int code) {
        switch (code) {
            case 403: {
                return true;
            }
            case 401: 
            case 440: {
                return false;
            }
        }
        return true;
    }

    private static void autorizar(ConfiguracaoDTO config) {
        HTTPURLConnection httpAutorization = new HTTPURLConnection();
        JSONObject json = new JSONObject();
        json.put("login", (Object)config.getUsuario());
        json.put("senha", (Object)config.getSenha());
        String url = config.getUrlSoftware() + PATH_AUTORIZAR;
        RespostaHTTP respostaAutorizacao = httpAutorization.get(url).setBody(json.toString()).setDoOutput(true).addHeader("Content-Type", "application/json;charset=UTF-8").startRequest();
        switch (respostaAutorizacao.getStatus()) {
            case 200: {
                token = respostaAutorizacao.getResponseHeaders().get("Authorization").get(0);
                break;
            }
            case 412: {
                throw new ConfiguracaoException("Usu\u00e1rio e senha incorretos.", ConfiguracaoExceptionEnum.USUARIO_SENHA_INCORRETOS);
            }
            default: {
                ConexaoService.checkResponse(respostaAutorizacao, url);
            }
        }
    }

    private static void checkResponse(RespostaHTTP resposta, String url) {
        if (resposta.getStatus() > 300) {
            switch (resposta.getStatus()) {
                case 412: {
                    throw new PreCondicaoException(new JSONObject(resposta.getResponse()).getString("message"));
                }
                case 404: {
                    throw new ConnectionException("URL n\u00e3o encontrada. URL : " + url);
                }
                case 403: {
                    break;
                }
                default: {
                    try {
                        String message = new JSONObject(resposta.getResponse()).getString("message");
                        throw new RuntimeException("Erro no servi\u00e7o. C\u00f3digo: " + resposta.getStatus() + ". Mensagem: " + message + " URL : " + url);
                    }
                    catch (JSONException e) {
                        throw new RuntimeException("Erro no servi\u00e7o. C\u00f3digo: " + resposta.getStatus() + ". URL : " + url);
                    }
                }
            }
        }
    }
}

