/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class NumeroUtil {
    private static DecimalFormat df;

    public static <T> T parteInteiraNumero(T numero) {
        if (numero instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)numero;
            return (T)new BigDecimal(b.intValue());
        }
        if (numero instanceof Integer) {
            return numero;
        }
        if (numero instanceof Float) {
            return (T)new Integer(((Float)numero).intValue());
        }
        if (numero instanceof Double) {
            return (T)new Integer(((Double)numero).intValue());
        }
        if (numero instanceof Long) {
            return (T)new Integer(((Long)numero).intValue());
        }
        throw new IllegalArgumentException("Tipo n\u00e3o suportado.");
    }

    public static <T> T parteDecimalNumero(T numero) {
        if (numero instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)numero;
            return (T)b.subtract(new BigDecimal(b.intValue()));
        }
        if (numero instanceof Integer) {
            return (T)new Integer(0);
        }
        if (numero instanceof Float) {
            Float f = (Float)numero;
            f = Float.valueOf(f.floatValue() - (float)f.intValue());
            return (T)f;
        }
        if (numero instanceof Double) {
            Double d = (Double)numero;
            d = d - (double)d.intValue();
            return (T)d;
        }
        if (numero instanceof Long) {
            Long l = (Long)numero;
            l = l - (long)l.intValue();
            return (T)l;
        }
        throw new IllegalArgumentException("Tipo n\u00e3o suportado.");
    }

    public static <T> String converterNumeroEmTextoFormatado(T numero) {
        return NumeroUtil.verificarEConverterTextoFormatado(numero, "", "", 2);
    }

    public static <T> String converterNumeroEmTextoFormatado(T numero, Integer qtdCasaDecimal) {
        return NumeroUtil.verificarEConverterTextoFormatado(numero, "", "", qtdCasaDecimal);
    }

    public static <T> String converterNumeroEmTextoFormatado(T numero, Integer qtdCasaDecimal, String prefixo, String sufixo) {
        return NumeroUtil.verificarEConverterTextoFormatado(numero, prefixo, sufixo, qtdCasaDecimal);
    }

    private static <T> String verificarEConverterTextoFormatado(T numero, String prefixo, String sufixo, Integer casaDecimal) {
        if (!prefixo.isEmpty()) {
            prefixo = "'" + prefixo + "'";
        }
        if (!sufixo.isEmpty()) {
            sufixo = "'" + sufixo + "'";
        }
        df = new DecimalFormat(prefixo + "##,###,###,##" + NumeroUtil.getQuantidadeZeros(casaDecimal) + sufixo, new DecimalFormatSymbols(new Locale("pt", "BR")));
        if (numero instanceof String) {
            return df.format(new BigDecimal((String)numero));
        }
        return df.format(numero);
    }

    private static String getQuantidadeZeros(Integer qtd) {
        if (qtd == 0) {
            return "0";
        }
        String formato = "0.";
        for (int i = 1; i <= qtd; ++i) {
            formato = formato + "0";
        }
        NumeroUtil.converterTextoFormatadoEmNumero(formato);
        return formato;
    }

    public static String converterTextoFormatadoEmNumero(String valor) {
        if (valor.contains("R$ ")) {
            valor = valor.substring(3, valor.length());
        }
        if (valor.contains(" %")) {
            valor = valor.substring(0, valor.indexOf(" %"));
        }
        return valor.replace(".", "").replace(",", ".");
    }

    public static <T> String definirCasasDecimais(T numero, int casasDecimais) {
        df = new DecimalFormat(NumeroUtil.getQuantidadeZeros(casasDecimais), new DecimalFormatSymbols(Locale.US));
        if (numero instanceof String) {
            return df.format(new BigDecimal((String)numero));
        }
        return df.format(numero);
    }
}

