/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.service;

import br.com.argus.cronos.comunicacao.ConexaoService;
import br.com.argus.cronos.comunicacao.RespostaHTTP;
import br.com.argus.cronos.config.ConfiguracaoDTO;
import br.com.argus.cronos.config.ConfigurationService;
import br.com.argus.cronos.gui.ExecucaoTelaCarregando;
import br.com.argus.cronos.gui.TelaCarregando;
import br.com.argus.cronos.gui.ViewService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.main.Main;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.swing.JOptionPane;
import org.json.JSONObject;

public class UpdateService {
    private static final String NOME_ARQUIVO_VERSAO_SERVIDOR = "cronos-auxiliar-impressao-setup";
    private static final String EXTENSAO_ARQUIVO_VERSAO_SERVIDOR = ".exe";

    public static void verificarAtualizacao() {
        ViewService.printResponseArea("Verificando por Atualiza\u00e7\u00f5es", TipoMensagem.INFO);
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        RespostaHTTP resp = ConexaoService.verificarConfiguracaoServidor();
        String r = resp.getResponse();
        System.out.println(r);
        JSONObject respostaJSON = new JSONObject(resp.getResponse());
        if (UpdateService.greaterThan(respostaJSON.getString("versaoAtual"), config.getVersao())) {
            config.setVersaoServidor(respostaJSON.getString("versaoAtual"));
            config.setUrlDownload(respostaJSON.getString("urlDownload"));
            config.setNomeVersaoServidor(respostaJSON.getString("nomeArquivo"));
            config.setAtualizado(false);
        } else {
            config.setAtualizado(true);
        }
        ConfigurationService.setConfiguration(config);
        UpdateService.exibirModalAtualizacao(config.isAtualizado());
    }

    public static boolean greaterThan(String version1, String version2) {
        if (version1.indexOf(".") > 0 && version2.indexOf(".") > 0) {
            int numberVersao2;
            int numberVersao1 = Integer.parseInt(version1.substring(0, version1.indexOf(".")));
            if (numberVersao1 > (numberVersao2 = Integer.parseInt(version2.substring(0, version2.indexOf("."))))) {
                return true;
            }
            if (numberVersao1 == numberVersao2) {
                return UpdateService.greaterThan(version1.substring(version1.indexOf(".") + 1), version2.substring(version2.indexOf(".") + 1));
            }
            return false;
        }
        boolean versao1PossuiMais1 = false;
        boolean versao2PossuiMais1 = false;
        if (version1.indexOf(".") > 0) {
            versao1PossuiMais1 = true;
            version1 = version1.substring(0, version1.indexOf("."));
        }
        if (version2.indexOf(".") > 0) {
            versao2PossuiMais1 = true;
            version2 = version2.substring(0, version2.indexOf("."));
        }
        Integer numberVersao1 = null;
        Integer numberVersao2 = null;
        try {
            numberVersao1 = Integer.parseInt(version1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            numberVersao2 = Integer.parseInt(version2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (numberVersao1 == null && numberVersao2 == null) {
            return false;
        }
        if (numberVersao1 != null && numberVersao2 == null) {
            return true;
        }
        if (numberVersao1 == null && numberVersao2 != null) {
            return false;
        }
        if (Objects.equals(numberVersao1, numberVersao2)) {
            if (versao2PossuiMais1) {
                return false;
            }
            return versao1PossuiMais1;
        }
        return numberVersao1 > numberVersao2;
    }

    public static String downloadNewVersion(TelaCarregando tela) throws IOException {
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        tela.getLabelStatus().setText("Verificando se o arquivo existe...");
        String caminhoArquivo = ConfigurationService.getConfigurationFolderName() + "/update/" + config.getNomeVersaoServidor();
        File arquivo = new File(caminhoArquivo);
        int option = 0;
        if (arquivo.exists()) {
            ViewService.printResponseArea("O arquivo da vers\u00e3o " + config.getVersaoServidor() + " j\u00e1 existe.", TipoMensagem.INFO);
            tela.getLabelStatus().setText("O arquivo j\u00e1 existe...");
            option = JOptionPane.showConfirmDialog(null, "O arquivo j\u00e1 existe?\nDeseja efetuar o download novamente?", "Confirmar", 0);
            if (option == 0) {
                ViewService.printResponseArea("Deletando arquivo da vers\u00e3o " + config.getVersaoServidor() + ".", TipoMensagem.INFO);
                arquivo.delete();
            }
        }
        if (option == 0) {
            ViewService.printResponseArea("Iniciando download da vers\u00e3o " + config.getVersaoServidor(), TipoMensagem.INFO);
            tela.getLabelStatus().setText("Efetuando download...");
            RespostaHTTP resp = ConexaoService.downloadNewVersion();
            ViewService.printResponseArea("Download da vers\u00e3o " + config.getVersaoServidor() + " finalizado.", TipoMensagem.INFO);
            new File(ConfigurationService.getConfigurationFolderName() + "/update/").mkdirs();
            tela.getLabelStatus().setText("Criando arquivo...");
            ViewService.printResponseArea("Salvando arquivo da vers\u00e3o " + config.getVersaoServidor() + " no computador.", TipoMensagem.INFO);
            try (FileOutputStream os = new FileOutputStream(caminhoArquivo);){
                ((OutputStream)os).write(resp.getArquivo());
            }
            catch (Exception e) {
                ViewService.printResponseArea("Erro ao baixar a nova vers\u00e3o. Tente novamente mais tarde.", TipoMensagem.ERROR);
            }
        }
        return caminhoArquivo;
    }

    public static void exibirModalAtualizacao(boolean modalSofwareAtualizado) {
        UpdateService.exibirModalAtualizacao(modalSofwareAtualizado, false);
    }

    public static void exibirModalAtualizacao(boolean modalSofwareAtualizado, boolean exibirMensagemDesatualizado) {
        final ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        System.out.println("No modal versao server: " + config.getVersaoServidor());
        System.out.println("Atualizado: " + config.isAtualizado());
        if (config.getVersaoServidor() != null) {
            if (!config.isAtualizado()) {
                ViewService.showTrayMessage("O Cronos Auxiliar de Impress\u00e3o est\u00e1 desatualizado.", TipoMensagem.WARNING);
                ViewService.abrirTelaPrincipal();
                ViewService.printResponseArea("Vers\u00e3o " + config.getVersaoServidor() + " encontrada no servidor para download. A vers\u00e3o atual do software \u00e9 " + config.getVersao() + ".", TipoMensagem.WARNING);
                int option = JOptionPane.showConfirmDialog(null, "Existe uma nova vers\u00e3o do Cronos Auxiliar de Impress\u00e3o dispon\u00edvel para download.\nA Vers\u00e3o Atual \u00e9 " + config.getVersao() + " e a vers\u00e3o " + config.getVersaoServidor() + " est\u00e1 dispon\u00edvel.\n\u00c9 importante que o software esteja sempre atualizado para evitar erros.\nDeseja fazer o download dessa nova vers\u00e3o?", "Confirmar", 0);
                System.out.println("option versao: " + option);
                if (option == 0) {
                    ViewService.exibirTelaCarregando(new ExecucaoTelaCarregando(){

                        @Override
                        public void executar(TelaCarregando tela) {
                            try {
                                ViewService.printResponseArea("Iniciando download da vers\u00e3o " + config.getVersaoServidor(), TipoMensagem.INFO);
                                String caminhoArquivo = UpdateService.downloadNewVersion(tela);
                                Runtime r = Runtime.getRuntime();
                                ViewService.printResponseArea("Executando instalador da vers\u00e3o " + config.getVersaoServidor(), TipoMensagem.INFO);
                                Process p = r.exec(caminhoArquivo);
                                tela.setVisible(false);
                                Main.fecharPrograma(false);
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(null, "Ocorreu um erro ao efetuar o download.");
                            }
                        }

                        @Override
                        public void onClose(TelaCarregando tela) {
                            int o = JOptionPane.showConfirmDialog(null, "Tem certeza que deseja cancelar o download?", "Confirmar", 0);
                            if (o == 0) {
                                tela.setVisible(false);
                            }
                        }
                    });
                }
            } else if (modalSofwareAtualizado) {
                JOptionPane.showMessageDialog(null, "O Software est\u00e1 atualizado.");
            }
        }
    }
}

