/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.service;

import br.com.argus.cronos.comunicacao.ConexaoService;
import br.com.argus.cronos.comunicacao.RespostaHTTP;
import br.com.argus.cronos.config.ConfigurationService;
import br.com.argus.cronos.dto.PedidoDTO;
import br.com.argus.cronos.exception.ConfiguracaoException;
import br.com.argus.cronos.exception.ConnectionException;
import br.com.argus.cronos.gui.TelaPedidos;
import br.com.argus.cronos.gui.TipoIconeStatus;
import br.com.argus.cronos.gui.ViewService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.service.ThreadService;
import br.com.argus.cronos.util.NumeroUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.swing.table.DefaultTableModel;

public class PedidoService {
    private static List<PedidoDTO> listaPedidos = new ArrayList<PedidoDTO>();
    private static PedidoDTO pedidoSelecionado;
    private static final String PATH_FILE = "/auxiliarpedidos.properties";

    public static void verificarPedidos(boolean forcada) {
        try {
            ViewService.setStatus("Consultando pedido.", TipoIconeStatus.LOAD);
            RespostaHTTP resposta = ConexaoService.verificarPedidos(forcada);
            if (resposta.getStatus() == 200) {
                ViewService.setStatus("Pedido(s) encontradado(s).", TipoIconeStatus.LOAD);
                Gson gson = new GsonBuilder().create();
                List listaPedidos = (List)gson.fromJson(resposta.getResponse(), new TypeToken<List<PedidoDTO>>(){}.getType());
                PedidoService.montarTabelaPedidos(listaPedidos);
            } else {
                ViewService.setStatus("Nenhum pedido encontrado.", TipoIconeStatus.EMPTY);
                if (forcada) {
                    ViewService.showTrayMessage("Nenhum pedido encontrado.", TipoMensagem.INFO);
                }
            }
        }
        catch (ConnectionException e) {
            ViewService.setStatus("Falha ao conectar com o servidor.", TipoIconeStatus.STOP);
            ViewService.printResponseArea("Falha ao conectar com o servidor. Preparando para novas tentativas.", TipoMensagem.WARNING, e);
            if (forcada) {
                ViewService.showTrayMessage("Falha ao conectar com o servidor. Preparando para novas tentativas.", TipoMensagem.ERROR);
            }
        }
        catch (ConfiguracaoException e) {
            String mensagem = "";
            String status = "Erro de configura\u00e7\u00f5es.";
            switch (e.motivo) {
                case ERRO_AO_GRAVAR_ARQUIVO: {
                    mensagem = "Erro ao gravar no arquivo de configura\u00e7\u00f5es.";
                    break;
                }
                case ERRO_AO_LER_ARQUIVO_CONFIGURACAO: {
                    mensagem = "Erro ao ler o arquivo de configura\u00e7\u00f5es.";
                    break;
                }
                case FALTA_CONFIGURACAO: {
                    mensagem = "O sistema n\u00e3o possui configura\u00e7\u00f5es.";
                    break;
                }
                case USUARIO_SENHA_INCORRETOS: {
                    mensagem = "Usu\u00e1rio e senha configurados est\u00e3o incorretos.";
                }
            }
            ViewService.printResponseArea(mensagem, TipoMensagem.ERROR, e);
            ViewService.setStatus(status, TipoIconeStatus.STOP);
            ViewService.showTrayMessage(mensagem, TipoMensagem.ERROR);
            ThreadService.pararVerificacao();
        }
        catch (Exception e) {
            ViewService.printResponseArea("Erro desconhecido. Causa: " + e.getMessage(), TipoMensagem.ERROR, e);
            ViewService.setStatus("Erro desconhecido.", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro desconhecido. " + e.getMessage(), TipoMensagem.ERROR);
        }
    }

    public static void montarTabelaPedidos(List<PedidoDTO> listaPedidosDTO) {
        TelaPedidos telaPedidos = ViewService.getTelaPedidos();
        DefaultTableModel model = (DefaultTableModel)telaPedidos.getTabelaPedidos().getModel();
        if (listaPedidosDTO != null) {
            for (PedidoDTO pedidoDTO : listaPedidosDTO) {
                boolean achou = false;
                for (int i = 0; i < model.getRowCount(); ++i) {
                    if (!pedidoDTO.getIdPedido().equals(Integer.parseInt(model.getValueAt(i, 0).toString()))) continue;
                    achou = true;
                    model.removeRow(i);
                    PedidoService.removerPedidoLista(pedidoDTO.getIdPedido());
                    if (pedidoDTO.getEtapa().equals("Cancelado") || pedidoDTO.getEtapa().equals("Conclu\u00eddo")) continue;
                    BigDecimal valorRestante = new BigDecimal(NumeroUtil.converterTextoFormatadoEmNumero(pedidoDTO.getValorTotalFinal()));
                    BigDecimal valorPago = BigDecimal.ZERO;
                    if (!pedidoDTO.getValorPago().isEmpty()) {
                        valorPago = new BigDecimal(NumeroUtil.converterTextoFormatadoEmNumero(pedidoDTO.getValorPago()));
                    }
                    pedidoDTO.setValorPago(NumeroUtil.converterNumeroEmTextoFormatado(valorPago, 2, "R$ ", ""));
                    valorRestante = valorRestante.subtract(valorPago);
                    pedidoDTO.setValorRestante(NumeroUtil.converterNumeroEmTextoFormatado(valorRestante, 2, "R$ ", ""));
                    Object[] linha = new Object[]{pedidoDTO.getIdPedido() + "", pedidoDTO.getDescricao(), pedidoDTO.getDataHora(), pedidoDTO.getValorTotalFinal(), pedidoDTO.getValorRestante()};
                    model.insertRow(i, linha);
                    listaPedidos.add(pedidoDTO);
                }
                if (achou) continue;
                BigDecimal valorRestante = new BigDecimal(NumeroUtil.converterTextoFormatadoEmNumero(pedidoDTO.getValorTotalFinal()));
                BigDecimal valorPago = BigDecimal.ZERO;
                if (!pedidoDTO.getValorPago().isEmpty()) {
                    valorPago = new BigDecimal(NumeroUtil.converterTextoFormatadoEmNumero(pedidoDTO.getValorPago()));
                }
                pedidoDTO.setValorPago(NumeroUtil.converterNumeroEmTextoFormatado(valorPago, 2, "R$ ", ""));
                valorRestante = valorRestante.subtract(valorPago);
                pedidoDTO.setValorRestante(NumeroUtil.converterNumeroEmTextoFormatado(valorRestante, 2, "R$ ", ""));
                Object[] linha = new Object[]{pedidoDTO.getIdPedido() + "", pedidoDTO.getDescricao(), pedidoDTO.getDataHora(), pedidoDTO.getValorTotalFinal(), pedidoDTO.getValorRestante()};
                model.addRow(linha);
                listaPedidos.add(pedidoDTO);
            }
        }
    }

    public static PedidoDTO getPedidoDTO(Integer idPedido) {
        for (PedidoDTO pedido : listaPedidos) {
            if (!pedido.getIdPedido().equals(idPedido)) continue;
            return pedido;
        }
        return null;
    }

    public static void salvarArquivoPedidos(String dataHoraUltimaAtualizacaoPedidos) throws ConfiguracaoException {
        try {
            String path = new File(ConfigurationService.getConfigurationFolderName()).getCanonicalPath();
            Properties properties = new Properties();
            if (!Objects.isNull(dataHoraUltimaAtualizacaoPedidos)) {
                properties.setProperty("config.dataHoraUltimaAtualizacaoPedidos", dataHoraUltimaAtualizacaoPedidos);
            }
            if (!Objects.isNull(listaPedidos)) {
                Gson gson = new GsonBuilder().create();
                String listaPedidosJSON = gson.toJson(listaPedidos, new TypeToken<List<PedidoDTO>>(){}.getType());
                properties.setProperty("config.mapaPedidos", listaPedidosJSON);
            }
            try (FileOutputStream fos = new FileOutputStream(path + PATH_FILE);){
                properties.store(fos, "CRONOS AUXILIAR PEDIDOS PROPERTIES:");
            }
        }
        catch (IOException ex) {
            ViewService.printResponseArea("Erro ao gravar o arquivo de pedidos salvos.", TipoMensagem.WARNING, ex);
        }
    }

    public static void getListaPedidosArquivo() {
        TelaPedidos telaPedidos = ViewService.getTelaPedidos();
        DefaultTableModel model = (DefaultTableModel)telaPedidos.getTabelaPedidos().getModel();
        if (listaPedidos.isEmpty() && model.getRowCount() == 0) {
            Gson gson = new GsonBuilder().create();
            try {
                String path = new File(ConfigurationService.getConfigurationFolderName()).getCanonicalPath();
                Properties properties = new Properties();
                FileInputStream fis = new FileInputStream(path + PATH_FILE);
                properties.load(fis);
                if (properties.getProperty("config.dataHoraUltimaAtualizacaoPedidos") != null) {
                    ConexaoService.dataHoraUltimaAtualizacaoPedidos = properties.getProperty("config.dataHoraUltimaAtualizacaoPedidos");
                }
                if (properties.getProperty("config.mapaPedidos") != null) {
                    List listaPedidosSalvas = (List)gson.fromJson(properties.getProperty("config.mapaPedidos"), new TypeToken<List<PedidoDTO>>(){}.getType());
                    PedidoService.montarTabelaPedidos(listaPedidosSalvas);
                }
            }
            catch (IOException e) {
                ViewService.printResponseArea("Erro ao abrir o arquivo de pedidos salvos.", TipoMensagem.WARNING, e);
            }
        }
    }

    private static boolean removerPedidoLista(Integer idPedido) {
        for (PedidoDTO pedido : listaPedidos) {
            if (!idPedido.equals(pedido.getIdPedido())) continue;
            listaPedidos.remove(pedido);
            return true;
        }
        return false;
    }
}

