/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.service;

import br.com.argus.cronos.comunicacao.ConexaoService;
import br.com.argus.cronos.comunicacao.RespostaHTTP;
import br.com.argus.cronos.config.ConfiguracaoDTO;
import br.com.argus.cronos.config.ConfiguracaoEnum;
import br.com.argus.cronos.config.ConfigurationService;
import br.com.argus.cronos.config.DefinicaoImpressoraDTO;
import br.com.argus.cronos.dto.ImpressaoDTO;
import br.com.argus.cronos.dto.PedidoDTO;
import br.com.argus.cronos.exception.ConfiguracaoException;
import br.com.argus.cronos.exception.ConfiguracaoExceptionEnum;
import br.com.argus.cronos.exception.ConnectionException;
import br.com.argus.cronos.gui.TelaPrincipal;
import br.com.argus.cronos.gui.TipoIconeStatus;
import br.com.argus.cronos.gui.ViewService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.service.PedidoService;
import br.com.argus.cronos.service.ThreadService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.json.JSONObject;

public class ImpressaoService {
    public static void carregarListaImpressoras() {
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        telaPrincipal.getComboBoxImpressoras().removeAllItems();
        telaPrincipal.getLabelStatusImpressoras().setText("Carregando...");
        ArrayList<String> listaImpressora = ImpressaoService.getListaImpressoras();
        if (listaImpressora.isEmpty()) {
            telaPrincipal.getLabelStatusImpressoras().setText("Nenhuma impressora encontrada.");
        } else {
            for (String imp : listaImpressora) {
                telaPrincipal.getComboBoxImpressoras().addItem(imp);
            }
            telaPrincipal.getLabelStatusImpressoras().setText("");
        }
    }

    public static void imprimirDocumentoConsultado(String nomeImpressora, byte[] arquivo) {
        try {
            PDDocument document = PDDocument.load((byte[])arquivo);
            ImpressaoService.imprimir(document, nomeImpressora);
        }
        catch (IOException ex) {
            ConfiguracaoDTO config = ConfigurationService.getConfiguration();
            if (config.isDebug()) {
                ViewService.printResponseArea("Erro ao tentar imprimir na impressora: " + nomeImpressora + ". Causa: " + ex.getMessage(), TipoMensagem.ERROR, ex);
            } else {
                ViewService.printResponseArea("Erro ao tentar imprimir na impressora: " + nomeImpressora + ". Verifique se a esta impressora est\u00e1 instalada em seu computador ou se o nome dela foi alterado.", TipoMensagem.ERROR, ex);
            }
            ViewService.setStatus("Erro ao tentar imprimir", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro ao tentar imprimir. Causa: " + ex.getMessage(), TipoMensagem.ERROR);
        }
    }

    public static void imprimirPaginaTeste(String nomeImpressora) throws IOException, PrinterException, URISyntaxException {
        File file = new File(System.getProperty("user.dir") + "\\teste\\PaginaTeste.pdf");
        PDDocument document = PDDocument.load((File)file);
        ImpressaoService.imprimir(document, nomeImpressora);
    }

    private static void imprimir(PDDocument document, String nomeImpressora) {
        try {
            ConfiguracaoEnum.TipoLarguraPapelEnum tipoLargura;
            ConfiguracaoEnum.TipoAlturaPapelEnum tipoAltura;
            ConfiguracaoEnum.ModeloPaginaEnum modeloPagina;
            PDFPageable pdfPage = new PDFPageable(document);
            PrintService impressoraService = ImpressaoService.getPrintService(nomeImpressora);
            PrinterJob impressao = PrinterJob.getPrinterJob();
            impressao.setPrintService(impressoraService);
            DefinicaoImpressoraDTO config = ConfigurationService.getImpressoraDTO(nomeImpressora);
            try {
                modeloPagina = ConfiguracaoEnum.ModeloPaginaEnum.getEnum(config.getModeloPagina().trim());
            }
            catch (NullPointerException e) {
                modeloPagina = ConfiguracaoEnum.ModeloPaginaEnum.PDF_DEFAULT;
            }
            try {
                tipoAltura = ConfiguracaoEnum.TipoAlturaPapelEnum.getEnum(config.getTipoAlturaPapel().trim());
            }
            catch (NullPointerException e) {
                tipoAltura = ConfiguracaoEnum.TipoAlturaPapelEnum.IMPRESSORA;
            }
            try {
                tipoLargura = ConfiguracaoEnum.TipoLarguraPapelEnum.getEnum(config.getTipoLarguraPapel().trim());
            }
            catch (NullPointerException e) {
                tipoLargura = ConfiguracaoEnum.TipoLarguraPapelEnum.PDF;
            }
            switch (modeloPagina) {
                case IMPRESSORA: {
                    PageFormat format = impressao.defaultPage();
                    impressao.setPrintable(pdfPage.getPrintable(0), format);
                    break;
                }
                case PDF_DEFAULT: {
                    impressao.setPrintable(pdfPage.getPrintable(0), pdfPage.getPageFormat(0));
                    break;
                }
                default: {
                    Double larguraPagina;
                    Double alturaPagina;
                    PageFormat format = pdfPage.getPageFormat(0);
                    Paper paper = format.getPaper();
                    try {
                        paper.setImageableArea(config.getAlinhamentoX(), config.getAlinhamentoY(), paper.getImageableWidth(), paper.getImageableHeight());
                    }
                    catch (NullPointerException e) {
                        paper.setImageableArea(0.0, 0.0, paper.getImageableWidth(), paper.getImageableHeight());
                    }
                    switch (tipoAltura) {
                        case IMPRESSORA: {
                            alturaPagina = impressao.getPageFormat(null).getHeight();
                            break;
                        }
                        case PDF: {
                            alturaPagina = paper.getHeight();
                            break;
                        }
                        default: {
                            alturaPagina = impressao.getPageFormat(null).getHeight();
                        }
                    }
                    switch (tipoLargura) {
                        case IMPRESSORA: {
                            larguraPagina = impressao.getPageFormat(null).getWidth();
                            break;
                        }
                        case PDF: {
                            larguraPagina = paper.getWidth();
                            break;
                        }
                        default: {
                            larguraPagina = paper.getWidth();
                        }
                    }
                    paper.setSize(larguraPagina, alturaPagina);
                    format.setPaper(paper);
                    impressao.setPrintable(pdfPage.getPrintable(0), format);
                }
            }
            impressao.print();
            document.close();
        }
        catch (PrinterException | IOException ex) {
            ConfiguracaoDTO config = ConfigurationService.getConfiguration();
            if (config.isDebug()) {
                ViewService.printResponseArea("Erro ao tentar imprimir na impressora: " + nomeImpressora + ". Causa: " + ex.getMessage(), TipoMensagem.ERROR, ex);
                ViewService.setStatus("Erro ao tentar imprimir", TipoIconeStatus.STOP);
                ViewService.showTrayMessage("Erro ao tentar imprimir na impressora: " + nomeImpressora + ". Causa: " + ex.getMessage(), TipoMensagem.ERROR);
            }
            ViewService.printResponseArea("Erro ao tentar imprimir na impressora: " + nomeImpressora + ". Verifique se a esta impressora est\u00e1 instalada em seu computador ou se o nome dela foi alterado.", TipoMensagem.ERROR, ex);
            ViewService.setStatus("Erro ao tentar imprimir", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro ao tentar imprimir na impressora: " + nomeImpressora + ". Verifique se a esta impressora est\u00e1 instalada em seu computador ou se o nome dela foi alterado.", TipoMensagem.ERROR);
        }
    }

    private static PrintService getPrintService(String printerName) {
        PrintService[] printServices;
        for (PrintService printService : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
            if (!printService.getName().trim().equals(printerName)) continue;
            return printService;
        }
        return null;
    }

    public static ArrayList<String> getListaImpressoras() {
        PrintService[] printServices;
        ArrayList<String> listaImpressora = new ArrayList<String>();
        for (PrintService printService : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
            listaImpressora.add(printService.getName().trim());
        }
        return listaImpressora;
    }

    public static void verificarPendencias(boolean forcada) {
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        try {
            JSONObject obj;
            Gson gson;
            ViewService.setStatus("Consultando documentos.", TipoIconeStatus.LOAD);
            RespostaHTTP resposta = ConexaoService.verificarPendencias(forcada);
            switch (resposta.getStatus()) {
                case 200: {
                    List listaImpressao;
                    ViewService.setStatus("Documentos encontradados.", TipoIconeStatus.LOAD);
                    gson = new GsonBuilder().create();
                    try {
                        obj = new JSONObject(resposta.getResponse());
                        listaImpressao = (List)gson.fromJson(obj.getJSONArray("listaImpressao").toString(), new TypeToken<List<ImpressaoDTO>>(){}.getType());
                    }
                    catch (Exception e) {
                        listaImpressao = (List)gson.fromJson(resposta.getResponse(), new TypeToken<List<ImpressaoDTO>>(){}.getType());
                    }
                    if (config.isDebug()) {
                        ViewService.printResponseArea("----- VARRENDO ITENS PARA SEREM IMPRESSOS (DEBUG) ----", TipoMensagem.INFO);
                        ViewService.printResponseArea("----- ITENS P/ IMPRESSAO: " + listaImpressao.size(), TipoMensagem.INFO);
                    }
                    for (ImpressaoDTO impressaoDTO : listaImpressao) {
                        if (config.isDebug()) {
                            ViewService.printResponseArea("----- IMPRESSAO (DEBUG) ----", TipoMensagem.INFO);
                            ViewService.printResponseArea("         idPedido: " + impressaoDTO.getIdPedido(), TipoMensagem.INFO);
                            ViewService.printResponseArea("         id: " + impressaoDTO.getId(), TipoMensagem.INFO);
                            ViewService.printResponseArea("         nome: " + impressaoDTO.getNome(), TipoMensagem.INFO);
                            ViewService.printResponseArea("         uuid: " + impressaoDTO.getUuidAuxiliar(), TipoMensagem.INFO);
                            ViewService.printResponseArea("         Path: " + impressaoDTO.getUrlPath(), TipoMensagem.INFO);
                            ViewService.printResponseArea("         idImpressora: " + impressaoDTO.getIdImpressora(), TipoMensagem.INFO);
                            ViewService.printResponseArea("----- VERIFICANDO UUID -------", TipoMensagem.INFO);
                        }
                        boolean imprimir = false;
                        if (impressaoDTO.getUuidAuxiliar() != null) {
                            if (impressaoDTO.getUuidAuxiliar().equals(config.getUuidAuxiliar())) {
                                imprimir = true;
                            }
                        } else {
                            imprimir = true;
                        }
                        if (!imprimir) continue;
                        ViewService.setStatus("Imprimindo.", TipoIconeStatus.PRINTING);
                        if (config.isDebug()) {
                            ViewService.printResponseArea("----- CONSULTANDO ARQUIVO NO SERVIDOR ----", TipoMensagem.INFO);
                        }
                        byte[] arquivo = ConexaoService.consultarArquivos(impressaoDTO.getId() != null ? impressaoDTO.getId() : impressaoDTO.getIdPedido(), impressaoDTO.getIdImpressora(), impressaoDTO.getUrlPath());
                        if (config.isDebug()) {
                            ViewService.printResponseArea("----- IMPRIMINDO DOCUMENTO " + (listaImpressao.indexOf(impressaoDTO) + 1) + " -------", TipoMensagem.INFO);
                        }
                        ImpressaoService.imprimirDocumentoConsultado(impressaoDTO.getNome(), arquivo);
                        if (config.isDebug()) {
                            ViewService.printResponseArea("------IMPRESSO COM SUCESSO-----", TipoMensagem.INFO);
                            ViewService.printResponseArea("-------------------------------", TipoMensagem.INFO);
                        }
                        if (listaImpressao.indexOf(impressaoDTO) >= listaImpressao.size() - 1) continue;
                        Thread.sleep(1000L);
                        if (!config.isDebug()) continue;
                        ViewService.printResponseArea("ESPERANDO PROXIMO...........", TipoMensagem.INFO);
                        ViewService.printResponseArea("----------------------------", TipoMensagem.INFO);
                    }
                    break;
                }
                case 403: {
                    throw new ConfiguracaoException("Erro 403. UUID n\u00e3o encontrado.", ConfiguracaoExceptionEnum.UUID_NAO_UTILIZADA);
                }
                default: {
                    ViewService.setStatus("Nenhum documento encontrado.", TipoIconeStatus.EMPTY);
                    if (!forcada) break;
                    ViewService.showTrayMessage("Nenhum documento encontrado.", TipoMensagem.INFO);
                }
            }
            if (!resposta.getResponse().equals("")) {
                gson = new GsonBuilder().create();
                try {
                    obj = new JSONObject(resposta.getResponse());
                    List listaPedidos = (List)gson.fromJson(obj.getJSONArray("pedidosPendentes").toString(), new TypeToken<List<PedidoDTO>>(){}.getType());
                    String dataHoraUltimaAtualizacaoPedidos = obj.has("dataHoraUltimaAtualizacaoPedidos") ? obj.getString("dataHoraUltimaAtualizacaoPedidos") : null;
                    PedidoService.montarTabelaPedidos(listaPedidos);
                    if (!Objects.isNull(dataHoraUltimaAtualizacaoPedidos)) {
                        ConexaoService.dataHoraUltimaAtualizacaoPedidos = dataHoraUltimaAtualizacaoPedidos;
                    }
                    PedidoService.salvarArquivoPedidos(dataHoraUltimaAtualizacaoPedidos);
                }
                catch (Exception e) {
                    System.out.println("Deu erro nos pedidos");
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (ConnectionException e) {
            ViewService.setStatus("Falha ao conectar com o servidor.", TipoIconeStatus.STOP);
            ViewService.printResponseArea("Falha ao conectar com o servidor. Preparando para novas tentativas.", TipoMensagem.WARNING, e);
            if (config.isDebug()) {
                ViewService.printResponseArea(e.getMessage(), TipoMensagem.ERROR);
                ViewService.printResponseArea(e.getCause().toString(), TipoMensagem.ERROR);
                ViewService.printResponseArea("-------------------------------", TipoMensagem.INFO);
                ViewService.printResponseArea("-------------------------------", TipoMensagem.INFO);
            }
            if (forcada) {
                ViewService.showTrayMessage("Falha ao conectar com o servidor. Preparando para novas tentativas.", TipoMensagem.ERROR);
            }
        }
        catch (ConfiguracaoException e) {
            String mensagem = "";
            String status = "Erro de configura\u00e7\u00f5es.";
            switch (e.motivo) {
                case ERRO_AO_GRAVAR_ARQUIVO: {
                    mensagem = "Erro ao gravar no arquivo de configura\u00e7\u00f5es.";
                    break;
                }
                case ERRO_AO_LER_ARQUIVO_CONFIGURACAO: {
                    mensagem = "Erro ao ler o arquivo de configura\u00e7\u00f5es.";
                    break;
                }
                case FALTA_CONFIGURACAO: {
                    mensagem = "O sistema n\u00e3o possui configura\u00e7\u00f5es.";
                    break;
                }
                case USUARIO_SENHA_INCORRETOS: {
                    mensagem = "Usu\u00e1rio e senha configurados est\u00e3o incorretos.";
                    break;
                }
                case UUID_NAO_UTILIZADA: {
                    mensagem = "UUID deste auxiliar n\u00e3o est\u00e1 sendo utilizado.";
                }
            }
            ViewService.printResponseArea(mensagem, TipoMensagem.ERROR, e);
            ViewService.setStatus(status, TipoIconeStatus.STOP);
            ViewService.showTrayMessage(mensagem, TipoMensagem.ERROR);
            ThreadService.pararVerificacao();
        }
        catch (Exception e) {
            ViewService.printResponseArea("Erro desconhecido. Causa: " + e.getMessage(), TipoMensagem.ERROR, e);
            ViewService.setStatus("Erro desconhecido.", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("Erro desconhecido. " + e.getMessage(), TipoMensagem.ERROR);
        }
    }
}

