/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.config;

import br.com.argus.cronos.comunicacao.ConexaoService;
import br.com.argus.cronos.config.ConfiguracaoDTO;
import br.com.argus.cronos.config.ConfiguracaoEnum;
import br.com.argus.cronos.config.DefinicaoImpressoraDTO;
import br.com.argus.cronos.exception.ConfiguracaoException;
import br.com.argus.cronos.exception.ConfiguracaoExceptionEnum;
import br.com.argus.cronos.gui.TelaPrincipal;
import br.com.argus.cronos.gui.ViewService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.main.Main;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;

public class ConfigurationService {
    private static final String PATH_FILE = "/auxiliar.properties";
    private static ConfiguracaoDTO configuration;
    private static String PATH_CONFIGURATION;
    public static final String NOME_SOFTWARE = "Cronos Auxiliar de Impress\u00e3o";
    private static final String IV_KEY = "?QqQ~/\"6BVq3_PkD";
    private static final String KEY = "&&XiACFa77P<sLka";

    public static String getConfigurationFolderName() {
        File file;
        if (PATH_CONFIGURATION == null && !(file = new File(PATH_CONFIGURATION = System.getProperty("user.home") + "\\.aux-impressao-config\\")).exists()) {
            file.mkdir();
        }
        return PATH_CONFIGURATION;
    }

    public static void setConfiguration(ConfiguracaoDTO config) throws ConfiguracaoException {
        try {
            String path = new File(ConfigurationService.getConfigurationFolderName()).getCanonicalPath();
            Properties properties = new Properties();
            properties.setProperty("config.usuario", config.getUsuario());
            properties.setProperty("config.senha", ConfigurationService.encryptText(config.getSenha()));
            properties.setProperty("config.urlSoftware", config.getUrlSoftware());
            properties.setProperty("config.iniciarMinimizado", config.isIniciarMinimizado() + "");
            properties.setProperty("config.urlVerificacao", config.getUrlVerificacao());
            properties.setProperty("config.sistema", config.getSistema());
            properties.setProperty("config.uuidAuxiliar", config.getUuidAuxiliar());
            if (config.getNomeVersaoServidor() != null) {
                properties.setProperty("config.nomeVersaoServidor", config.getNomeVersaoServidor());
            }
            if (config.getVersaoServidor() != null) {
                properties.setProperty("config.versaoServidor", config.getVersaoServidor());
            }
            if (config.getUrlDownload() != null) {
                properties.setProperty("config.urlDownload", config.getUrlDownload());
            }
            properties.setProperty("config.debug", config.isDebug() + "");
            properties.setProperty("config.definicoesImpressoraJSON", config.getDefinicoesImpressoraJSON() == null ? ConfigurationService.getDefinicoesImpressoraVazio() : config.getDefinicoesImpressoraJSON());
            Properties propertiesProject = new Properties();
            propertiesProject.load(Main.class.getClassLoader().getResourceAsStream("project.properties"));
            properties.setProperty("config.versao", propertiesProject.getProperty("version"));
            TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
            telaPrincipal.getLabelVersao().setText(propertiesProject.getProperty("version"));
            try (FileOutputStream fos = new FileOutputStream(path + PATH_FILE);){
                properties.store(fos, "CRONOS AUXILIAR PROPERTIES:");
            }
            configuration = config;
        }
        catch (IOException ex) {
            throw new ConfiguracaoException("Erro ao gravar o arquivo de configura\u00e7\u00e3o.", ex, ConfiguracaoExceptionEnum.ERRO_AO_GRAVAR_ARQUIVO);
        }
    }

    public static ConfiguracaoDTO getConfiguration() throws ConfiguracaoException {
        ConfiguracaoDTO config = new ConfiguracaoDTO();
        if (configuration != null) {
            return configuration;
        }
        try {
            String path = new File(ConfigurationService.getConfigurationFolderName()).getCanonicalPath();
            Properties properties = new Properties();
            FileInputStream fis = new FileInputStream(path + PATH_FILE);
            properties.load(fis);
            config.setUuidAuxiliar(properties.getProperty("config.uuidAuxiliar"));
            config.setUrlVerificacao(properties.getProperty("config.urlVerificacao"));
            config.setSistema(properties.getProperty("config.sistema"));
            config.setSenha(ConfigurationService.decryptText(properties.getProperty("config.senha")));
            config.setUrlSoftware(properties.getProperty("config.urlSoftware"));
            config.setUsuario(properties.getProperty("config.usuario"));
            Properties propertiesProject = new Properties();
            propertiesProject.load(Main.class.getClassLoader().getResourceAsStream("project.properties"));
            config.setVersao(propertiesProject.getProperty("version"));
            config.setVersaoServidor(properties.getProperty("config.versaoServidor"));
            config.setNomeVersaoServidor(properties.getProperty("config.nomeVersaoServidor"));
            config.setUrlDownload(properties.getProperty("config.urlDownload"));
            boolean iniciarMinimizado = properties.getProperty("config.iniciarMinimizado") == null ? false : Boolean.parseBoolean(properties.getProperty("config.iniciarMinimizado"));
            config.setIniciarMinimizado(iniciarMinimizado);
            boolean debug = properties.getProperty("config.debug") == null ? false : Boolean.parseBoolean(properties.getProperty("config.debug"));
            config.setDebug(debug);
            config.setDefinicoesImpressoraJSON(properties.getProperty("config.definicoesImpressoraJSON") == null ? ConfigurationService.getDefinicoesImpressoraVazio() : properties.getProperty("config.definicoesImpressoraJSON"));
        }
        catch (IOException e) {
            if (e.getMessage().contains("(O sistema n\u00e3o pode encontrar o arquivo especificado)")) {
                throw new ConfiguracaoException("Configure o sistema antes do uso.", e, ConfiguracaoExceptionEnum.FALTA_CONFIGURACAO);
            }
            throw new ConfiguracaoException("Erro ao abrir o arquivo de configura\u00e7\u00e3o", e, ConfiguracaoExceptionEnum.ERRO_AO_LER_ARQUIVO_CONFIGURACAO);
        }
        return config;
    }

    public static void preencherInputConfiguracao() {
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        telaPrincipal.getInputSenha().setText(config.getSenha());
        telaPrincipal.getInputUrl().setText(config.getUrlSoftware());
        telaPrincipal.getInputUsuario().setText(config.getUsuario());
        telaPrincipal.getCheckBoxIniciarMinimizado().setSelected(config.isIniciarMinimizado());
        telaPrincipal.getCheckBoxDebug().setSelected(config.isDebug());
        telaPrincipal.getInputURLVerificacao().setText(config.getUrlVerificacao());
        telaPrincipal.getInputUuidAuxiliar().setText(config.getUuidAuxiliar());
        telaPrincipal.getLabelVersao().setText(config.getVersao());
        if (config.getSistema() != null) {
            telaPrincipal.getComboBoxSistema().setSelectedItem(config.getSistema());
        } else {
            telaPrincipal.getComboBoxSistema().setSelectedIndex(0);
        }
    }

    public static void salvarConfiguracoesGerais() {
        ConfigurationService.salvarConfiguracoesGerais(null);
    }

    public static void salvarConfiguracoesGerais(ConfiguracaoEnum.SistemaEnum sistema) {
        ConfiguracaoDTO config;
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        try {
            config = ConfigurationService.getConfiguration();
        }
        catch (ConfiguracaoException ex) {
            config = new ConfiguracaoDTO();
            config.setDefinicoesImpressoraJSON(ConfigurationService.getDefinicoesImpressoraVazio());
        }
        if (sistema != null) {
            switch (sistema) {
                case ARGUS_CHEF: {
                    config.setUrlSoftware(ConfiguracaoEnum.SistemaEnum.ARGUS_CHEF.urlServidor);
                    config.setUrlVerificacao(ConfiguracaoEnum.SistemaEnum.ARGUS_CHEF.urlVerificacao);
                    config.setSistema(ConfiguracaoEnum.SistemaEnum.ARGUS_CHEF.sistema);
                    telaPrincipal.getInputUrl().setText(ConfiguracaoEnum.SistemaEnum.ARGUS_CHEF.urlServidor);
                    telaPrincipal.getInputURLVerificacao().setText(ConfiguracaoEnum.SistemaEnum.ARGUS_CHEF.urlVerificacao);
                    telaPrincipal.getComboBoxSistema().setSelectedItem(ConfiguracaoEnum.SistemaEnum.ARGUS_CHEF.sistema);
                    break;
                }
                case ARGUS_MANAGER: {
                    config.setUrlSoftware(ConfiguracaoEnum.SistemaEnum.ARGUS_MANAGER.urlServidor);
                    config.setUrlVerificacao(ConfiguracaoEnum.SistemaEnum.ARGUS_MANAGER.urlVerificacao);
                    config.setSistema(ConfiguracaoEnum.SistemaEnum.ARGUS_MANAGER.sistema);
                    telaPrincipal.getInputUrl().setText(ConfiguracaoEnum.SistemaEnum.ARGUS_MANAGER.urlServidor);
                    telaPrincipal.getInputURLVerificacao().setText(ConfiguracaoEnum.SistemaEnum.ARGUS_MANAGER.urlVerificacao);
                    telaPrincipal.getComboBoxSistema().setSelectedItem(ConfiguracaoEnum.SistemaEnum.ARGUS_MANAGER.sistema);
                    break;
                }
            }
        } else {
            config.setUrlSoftware(telaPrincipal.getInputUrl().getText());
            config.setUrlVerificacao(telaPrincipal.getInputURLVerificacao().getText());
            config.setSistema(telaPrincipal.getComboBoxSistema().getSelectedItem().toString());
        }
        char[] chars = telaPrincipal.getInputSenha().getPassword();
        String password = String.valueOf(chars);
        config.setSenha(password);
        config.setUsuario(telaPrincipal.getInputUsuario().getText());
        config.setIniciarMinimizado(telaPrincipal.getCheckBoxIniciarMinimizado().isSelected());
        config.setDebug(telaPrincipal.getCheckBoxDebug().isSelected());
        if (telaPrincipal.getInputUuidAuxiliar().getText().equals("")) {
            telaPrincipal.getInputUuidAuxiliar().setText(UUID.randomUUID().toString());
        }
        config.setUuidAuxiliar(telaPrincipal.getInputUuidAuxiliar().getText());
        ConexaoService.zerarToken();
        try {
            ConfigurationService.setConfiguration(config);
            JOptionPane.showMessageDialog(null, "Informa\u00e7\u00f5es atualizadas com sucesso.", "Mensagem", 1);
            ViewService.printResponseArea("Configura\u00e7\u00f5es salvas com sucesso.", TipoMensagem.INFO);
        }
        catch (ConfiguracaoException ex) {
            ViewService.printResponseArea("N\u00e3o foi poss\u00edvel salvar as configura\u00e7\u00f5es. " + ex.getMessage(), TipoMensagem.ERROR);
            JOptionPane.showMessageDialog(null, "N\u00e3o foi poss\u00edvel salvar as configura\u00e7\u00f5es. " + ex.getMessage(), "Erro", 0);
        }
        catch (Exception ex) {
            ViewService.printResponseArea("Erro desconhecido. Causa: " + ex.getMessage(), TipoMensagem.ERROR, ex);
            JOptionPane.showMessageDialog(null, "Erro desconhecido. " + ex.getMessage(), "Erro", 0);
        }
    }

    public static void salvarConfiguracoesImpressora() {
        try {
            TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
            ConfiguracaoDTO config = ConfigurationService.getConfiguration();
            String nomeImpressora = (String)telaPrincipal.getComboBoxImpressoras().getSelectedItem();
            List<DefinicaoImpressoraDTO> listaDefinicaoImpressora = ConfigurationService.getListaDefinicaoImpressora();
            DefinicaoImpressoraDTO definicaoImpressoraDTO = ConfigurationService.getImpressoraDTO(nomeImpressora, listaDefinicaoImpressora);
            int alinhamentoX = telaPrincipal.getInputImpressoraX().getText().equals("") ? 0 : Integer.parseInt(telaPrincipal.getInputImpressoraX().getText());
            int alinhamentoY = telaPrincipal.getInputImpressoraY().getText().equals("") ? 0 : Integer.parseInt(telaPrincipal.getInputImpressoraY().getText());
            if (definicaoImpressoraDTO == null) {
                definicaoImpressoraDTO = new DefinicaoImpressoraDTO();
                definicaoImpressoraDTO.setNomeImpressora(nomeImpressora);
                listaDefinicaoImpressora.add(definicaoImpressoraDTO);
            }
            definicaoImpressoraDTO.setModeloPagina(telaPrincipal.getComboBoxModeloPaginas().getSelectedItem().toString());
            definicaoImpressoraDTO.setTipoAlturaPapel(telaPrincipal.getComboBoxTipoAlturaPapel().getSelectedItem().toString());
            definicaoImpressoraDTO.setTipoLarguraPapel(telaPrincipal.getComboBoxTipoLarguraPapel().getSelectedItem().toString());
            definicaoImpressoraDTO.setAlinhamentoX(alinhamentoX);
            definicaoImpressoraDTO.setAlinhamentoY(alinhamentoY);
            Gson gson = new GsonBuilder().create();
            String definicoesImpressoraJSON = gson.toJson(listaDefinicaoImpressora, new TypeToken<List<DefinicaoImpressoraDTO>>(){}.getType());
            config.setDefinicoesImpressoraJSON(definicoesImpressoraJSON);
            ConfigurationService.setConfiguration(config);
            ConexaoService.zerarToken();
            JOptionPane.showMessageDialog(null, "Defini\u00e7\u00f5es da impressora salvas com sucesso.", "Mensagem", 1);
            ViewService.printResponseArea("Defini\u00e7\u00f5es da impressora salvas com sucesso.", TipoMensagem.INFO);
        }
        catch (Exception e) {
            ViewService.printResponseArea("Erro ao tentar definir as configura\u00e7\u00f5es. Causa: " + e.getMessage(), TipoMensagem.ERROR, e);
            JOptionPane.showMessageDialog(null, "Erro ao tentar definir as configura\u00e7\u00f5es.", "Mensagem", 1);
        }
    }

    public static void zerarConfiguracoesImpressora() {
        try {
            ConfiguracaoDTO config;
            TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
            try {
                config = ConfigurationService.getConfiguration();
            }
            catch (ConfiguracaoException ex) {
                config = new ConfiguracaoDTO();
            }
            config.setDefinicoesImpressoraJSON(ConfigurationService.getDefinicoesImpressoraVazio());
            ConfigurationService.setConfiguration(config);
            telaPrincipal.getInputImpressoraX().setText("");
            telaPrincipal.getInputImpressoraY().setText("");
            JOptionPane.showMessageDialog(null, "Defini\u00e7\u00f5es da impressora zeraradas com sucesso.", "Mensagem", 1);
            ViewService.printResponseArea("Defini\u00e7\u00f5es da impressora zeraradas com sucesso.", TipoMensagem.INFO);
        }
        catch (Exception e) {
            ViewService.printResponseArea("Erro ao tentar zerar as configura\u00e7\u00f5es da impressora. Causa: " + e.getMessage(), TipoMensagem.ERROR, e);
            JOptionPane.showMessageDialog(null, "Erro ao tentar zerar as configura\u00e7\u00f5es da impressora.", "Mensagem", 1);
        }
    }

    public static void buscarConfiguracaoImpressora() {
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        String impressora = (String)telaPrincipal.getComboBoxImpressoras().getSelectedItem();
        if (impressora != null) {
            List<DefinicaoImpressoraDTO> listaDefinicaoImpressora = ConfigurationService.getListaDefinicaoImpressora();
            DefinicaoImpressoraDTO definicaoImpressoraDTO = ConfigurationService.getImpressoraDTO(impressora, listaDefinicaoImpressora);
            if (definicaoImpressoraDTO == null) {
                telaPrincipal.getInputImpressoraX().setText("");
                telaPrincipal.getInputImpressoraY().setText("");
            } else {
                telaPrincipal.getInputImpressoraX().setText(definicaoImpressoraDTO.getAlinhamentoX() + "");
                telaPrincipal.getInputImpressoraY().setText(definicaoImpressoraDTO.getAlinhamentoY() + "");
                if (definicaoImpressoraDTO.getModeloPagina() != null) {
                    telaPrincipal.getComboBoxModeloPaginas().setSelectedItem(definicaoImpressoraDTO.getModeloPagina());
                } else {
                    telaPrincipal.getComboBoxModeloPaginas().setSelectedIndex(0);
                }
                if (definicaoImpressoraDTO.getTipoAlturaPapel() != null) {
                    telaPrincipal.getComboBoxTipoAlturaPapel().setSelectedItem(definicaoImpressoraDTO.getTipoAlturaPapel());
                } else {
                    telaPrincipal.getComboBoxTipoAlturaPapel().setSelectedIndex(0);
                }
                if (definicaoImpressoraDTO.getTipoLarguraPapel() != null) {
                    telaPrincipal.getComboBoxTipoLarguraPapel().setSelectedItem(definicaoImpressoraDTO.getTipoLarguraPapel());
                } else {
                    telaPrincipal.getComboBoxTipoLarguraPapel().setSelectedIndex(0);
                }
            }
        }
    }

    private static List<DefinicaoImpressoraDTO> getListaDefinicaoImpressora() {
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        Gson gson = new GsonBuilder().create();
        List listaDefinicaoImpressora = (List)gson.fromJson(config.getDefinicoesImpressoraJSON(), new TypeToken<List<DefinicaoImpressoraDTO>>(){}.getType());
        return listaDefinicaoImpressora;
    }

    private static String getDefinicoesImpressoraVazio() {
        return "[]";
    }

    private static DefinicaoImpressoraDTO getImpressoraDTO(String nomeImpressora, List<DefinicaoImpressoraDTO> listaDefinicaoImpressora) {
        for (DefinicaoImpressoraDTO definicaoImpressoraDTO : listaDefinicaoImpressora) {
            if (!definicaoImpressoraDTO.getNomeImpressora().equals(nomeImpressora)) continue;
            return definicaoImpressoraDTO;
        }
        return null;
    }

    public static DefinicaoImpressoraDTO getImpressoraDTO(String nomeImpressora) {
        for (DefinicaoImpressoraDTO definicaoImpressoraDTO : ConfigurationService.getListaDefinicaoImpressora()) {
            if (!definicaoImpressoraDTO.getNomeImpressora().equals(nomeImpressora)) continue;
            return definicaoImpressoraDTO;
        }
        return null;
    }

    private static String encryptText(String texto) {
        try {
            Cipher encripta = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
            SecretKeySpec key = new SecretKeySpec(KEY.getBytes("UTF-8"), "AES");
            encripta.init(1, (Key)key, new IvParameterSpec(IV_KEY.getBytes("UTF-8")));
            byte[] bytes = encripta.doFinal(texto.getBytes("UTF-8"));
            String encryptString = "";
            for (int i = 0; i < bytes.length; ++i) {
                encryptString = encryptString + new Integer(bytes[i]) + " ";
            }
            return encryptString;
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException("Erro ao criptografar o texto.");
        }
    }

    private static String decryptText(String texto) {
        if (texto == null) {
            return "";
        }
        if (texto.equals("")) {
            return "";
        }
        try {
            byte[] textoencriptado = ConfigurationService.converterStringEmBytes(texto);
            Cipher decripta = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
            SecretKeySpec key = new SecretKeySpec(KEY.getBytes("UTF-8"), "AES");
            decripta.init(2, (Key)key, new IvParameterSpec(IV_KEY.getBytes("UTF-8")));
            return new String(decripta.doFinal(textoencriptado), "UTF-8");
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException("Erro ao descriptografar o texto.");
        }
    }

    private static byte[] converterStringEmBytes(String texto) {
        String[] bytesString = texto.split(" ");
        byte[] bytes = new byte[bytesString.length];
        for (int i = 0; i < bytesString.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(bytesString[i]);
        }
        return bytes;
    }

    static {
        PATH_CONFIGURATION = null;
    }
}

