/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.comunicacao;

import br.com.argus.cronos.comunicacao.HTTPURLConnection;
import br.com.argus.cronos.comunicacao.RespostaHTTP;
import br.com.argus.cronos.config.ConfiguracaoDTO;
import br.com.argus.cronos.config.ConfiguracaoEnum;
import br.com.argus.cronos.config.ConfigurationService;
import br.com.argus.cronos.exception.ConfiguracaoException;
import br.com.argus.cronos.exception.ConfiguracaoExceptionEnum;
import br.com.argus.cronos.exception.ConnectionException;
import br.com.argus.cronos.exception.PreCondicaoException;
import br.com.argus.cronos.gui.ViewService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.service.ImpressaoService;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class ConexaoService {
    private static final int UNAUTHORIZED = 401;
    private static final int LOGIN_TIMEOUT = 440;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int PRE_CONDITION_FAILED = 412;
    private static final int SUCCESS = 200;
    private static final String PATH_AUTORIZAR = "/api/logar";
    private static final String PATH_RETORNO = "/api/pendencia/enviar";
    private static final String URL_UPDATE = "http://arquivos.arguscomputacao.com.br/Auxiliar%20impressao/instalador/update/";
    private static final String URL_CONFIG_AUXILIAR = "/api/auxiliar/configauxiliarimpressao";
    private static final String PATH_VERIFICACAO_PEDIDOS = "/api/pedido/cronosauxiliarpedidos";
    private static String token = "";
    private static boolean comPedidos = true;
    private static int contagemSolicitarPedidos = 0;
    private static int qtdRequisicoesAttListaPedido = 10;
    public static String dataHoraUltimaAtualizacaoPedidos;

    public static void zerarToken() {
        token = "";
    }

    public static RespostaHTTP verificarPendencias(boolean forcada) throws ConfiguracaoException {
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        HTTPURLConnection http = new HTTPURLConnection();
        String url = config.getUrlSoftware() + config.getUrlVerificacao();
        if (config.isDebug()) {
            ViewService.printResponseArea("-----Verificando Pendencias (DEBUG) -----", TipoMensagem.INFO);
            ViewService.printResponseArea("URL: " + url, TipoMensagem.INFO);
            ViewService.printResponseArea("For\u00e7ado: " + forcada, TipoMensagem.INFO);
        }
        if (contagemSolicitarPedidos == qtdRequisicoesAttListaPedido) {
            comPedidos = true;
            contagemSolicitarPedidos = 0;
        } else {
            comPedidos = false;
        }
        http.get(url).addParam("verificacaoForcada", forcada + "").addParam("uuidAuxiliar", config.getUuidAuxiliar()).addParam("debug", config.isDebug() + "").addHeader("Authorization", token);
        ConfiguracaoEnum.SistemaEnum sistema = ConfiguracaoEnum.SistemaEnum.getEnum(config.getSistema());
        switch (sistema) {
            case ARGUS_CHEF: {
                http.addParam("comPedidos", comPedidos + "");
                if (Objects.isNull(dataHoraUltimaAtualizacaoPedidos)) break;
                http.addParam("dataHoraUltimaAtualizacaoPedidos", dataHoraUltimaAtualizacaoPedidos);
                break;
            }
        }
        RespostaHTTP resposta = http.startRequest();
        if (config.isDebug()) {
            ViewService.printResponseArea("Status Resposta: " + resposta.getStatus(), TipoMensagem.INFO);
            ViewService.printResponseArea("Resposta: " + resposta.getResponse(), TipoMensagem.INFO);
            ViewService.printResponseArea("-----------------------------------------", TipoMensagem.INFO);
        }
        ++contagemSolicitarPedidos;
        if (ConexaoService.isAutorizado(resposta.getStatus())) {
            ConexaoService.checkResponse(resposta, url);
            return resposta;
        }
        ConexaoService.autorizar(config);
        return ConexaoService.verificarPendencias(forcada);
    }

    public static byte[] consultarArquivos(Integer id, Integer idImpressora, String urlPath) throws ConfiguracaoException {
        RespostaHTTP resposta;
        ConfiguracaoEnum.SistemaEnum sistema;
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        HTTPURLConnection http = new HTTPURLConnection();
        try {
            sistema = ConfiguracaoEnum.SistemaEnum.getEnum(config.getSistema());
            if (sistema == null) {
                throw new ConfiguracaoException("Selecione o sistema utilizado.", ConfiguracaoExceptionEnum.SELECIONAR_SISTEMA);
            }
        }
        catch (NullPointerException e) {
            throw new ConfiguracaoException("Configure o sistema antes do uso.", ConfiguracaoExceptionEnum.FALTA_CONFIGURACAO);
        }
        String url = config.getUrlSoftware() + urlPath;
        if (config.isDebug()) {
            ViewService.printResponseArea("-----Consultando Arquivo (DEBUG) -----", TipoMensagem.INFO);
            ViewService.printResponseArea("url: " + url, TipoMensagem.INFO);
            ViewService.printResponseArea("uuidAuxiliar: " + config.getUuidAuxiliar(), TipoMensagem.INFO);
            ViewService.printResponseArea("id: " + id, TipoMensagem.INFO);
            ViewService.printResponseArea("idImpressora: " + idImpressora, TipoMensagem.INFO);
        }
        switch (sistema) {
            case ARGUS_CHEF: {
                resposta = http.get(url).addParam("idPedido", id + "").addParam("idImpressora", idImpressora + "").addParam("mobile", "false").addParam("debug", config.isDebug() + "").addParam("uuidAuxiliar", config.getUuidAuxiliar()).addHeader("Authorization", token).startRequestFile();
                break;
            }
            default: {
                resposta = http.get(url).addParam("id", id + "").addParam("idImpressora", idImpressora + "").addParam("mobile", "false").addParam("debug", config.isDebug() + "").addParam("uuidAuxiliar", config.getUuidAuxiliar()).addHeader("Authorization", token).startRequestFile();
            }
        }
        if (config.isDebug()) {
            ViewService.printResponseArea("Status Resposta: " + resposta.getStatus(), TipoMensagem.INFO);
            ViewService.printResponseArea("Resposta: " + resposta.getResponse(), TipoMensagem.INFO);
            ViewService.printResponseArea("-----------------------------------------", TipoMensagem.INFO);
        }
        if (ConexaoService.isAutorizado(resposta.getStatus())) {
            ConexaoService.checkResponse(resposta, url);
            return resposta.getArquivo();
        }
        ConexaoService.autorizar(config);
        return ConexaoService.consultarArquivos(id, idImpressora, urlPath);
    }

    private static boolean isAutorizado(int code) {
        switch (code) {
            case 403: {
                return true;
            }
            case 401: 
            case 440: {
                return false;
            }
        }
        return true;
    }

    private static void autorizar(ConfiguracaoDTO config) {
        HTTPURLConnection httpAutorization = new HTTPURLConnection();
        String ip = "";
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            ip = socket.getLocalAddress().getHostAddress();
        }
        catch (SocketException | UnknownHostException socket) {
            // empty catch block
        }
        String nomeComputador = "";
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            nomeComputador = localMachine.getHostName();
        }
        catch (UnknownHostException localMachine) {
            // empty catch block
        }
        JSONObject json = new JSONObject();
        json.put("login", (Object)config.getUsuario());
        json.put("senha", (Object)config.getSenha());
        json.put("debug", config.isDebug());
        JSONObject objConfig = new JSONObject();
        objConfig.put("definicoesImpressoraJSON", (Object)config.getDefinicoesImpressoraJSON());
        objConfig.put("nomeVersaoServidor", (Object)config.getNomeVersaoServidor());
        objConfig.put("sistema", (Object)config.getSistema());
        objConfig.put("urlDownload", (Object)config.getUrlDownload());
        objConfig.put("urlSoftware", (Object)config.getUrlSoftware());
        objConfig.put("urlVerificacao", (Object)config.getUrlVerificacao());
        objConfig.put("usuario", (Object)config.getUsuario());
        objConfig.put("uuidAuxiliar", (Object)config.getUuidAuxiliar());
        objConfig.put("versao", (Object)config.getVersao());
        objConfig.put("versaoServidor", (Object)config.getVersaoServidor());
        objConfig.put("impressoras", ImpressaoService.getListaImpressoras());
        json.put("configJSON", (Object)objConfig.toString());
        json.put("ip", (Object)ip);
        json.put("nomeComputador", (Object)nomeComputador);
        String url = config.getUrlSoftware() + PATH_AUTORIZAR;
        if (config.isDebug()) {
            ViewService.printResponseArea("----- AUTORIZANDO (DEBUG) -----", TipoMensagem.INFO);
            ViewService.printResponseArea("URL: " + url, TipoMensagem.INFO);
            ViewService.printResponseArea("Login: " + config.getUsuario(), TipoMensagem.INFO);
        }
        RespostaHTTP respostaAutorizacao = httpAutorization.get(url).setBody(json.toString()).setDoOutput(true).addHeader("Content-Type", "application/json;charset=UTF-8").startRequest();
        if (config.isDebug()) {
            ViewService.printResponseArea("Status Resposta: " + respostaAutorizacao.getStatus(), TipoMensagem.INFO);
            ViewService.printResponseArea("Resposta: " + respostaAutorizacao.getResponse(), TipoMensagem.INFO);
            ViewService.printResponseArea("-----------------------------------------", TipoMensagem.INFO);
        }
        switch (respostaAutorizacao.getStatus()) {
            case 200: {
                token = respostaAutorizacao.getResponseHeaders().get("Authorization").get(0);
                break;
            }
            case 412: {
                throw new ConfiguracaoException("Usu\u00e1rio e senha incorretos.", ConfiguracaoExceptionEnum.USUARIO_SENHA_INCORRETOS);
            }
            default: {
                ConexaoService.checkResponse(respostaAutorizacao, url);
            }
        }
    }

    private static void checkResponse(RespostaHTTP resposta, String url) {
        if (resposta.getStatus() > 300) {
            switch (resposta.getStatus()) {
                case 412: {
                    throw new PreCondicaoException(new JSONObject(resposta.getResponse()).getString("message"));
                }
                case 404: {
                    throw new ConnectionException("URL n\u00e3o encontrada. URL : " + url);
                }
                case 403: {
                    break;
                }
                default: {
                    try {
                        String message = new JSONObject(resposta.getResponse()).getString("message");
                        throw new RuntimeException("Erro no servi\u00e7o. C\u00f3digo: " + resposta.getStatus() + ". Mensagem: " + message + " URL : " + url);
                    }
                    catch (JSONException e) {
                        throw new RuntimeException("Erro no servi\u00e7o. C\u00f3digo: " + resposta.getStatus() + ". URL : " + url);
                    }
                }
            }
        }
    }

    public static RespostaHTTP verificarConfiguracaoServidor() {
        HTTPURLConnection http = new HTTPURLConnection();
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        String url = config.getUrlSoftware() + URL_CONFIG_AUXILIAR;
        RespostaHTTP resposta = http.get(url).addHeader("Authorization", token).startRequest();
        if (ConexaoService.isAutorizado(resposta.getStatus())) {
            ConexaoService.checkResponse(resposta, url);
            return resposta;
        }
        ConexaoService.autorizar(config);
        return ConexaoService.verificarConfiguracaoServidor();
    }

    public static RespostaHTTP downloadNewVersion() {
        HTTPURLConnection httpFile = new HTTPURLConnection();
        RespostaHTTP respostaFile = httpFile.get(ConfigurationService.getConfiguration().getUrlDownload()).startRequestFile();
        return respostaFile;
    }

    public static RespostaHTTP verificarPedidos(boolean forcada) throws ConfiguracaoException {
        HTTPURLConnection http = new HTTPURLConnection();
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        String url = config.getUrlSoftware() + PATH_VERIFICACAO_PEDIDOS;
        RespostaHTTP resposta = http.get(url).addParam("verificacaoForcada", forcada + "").addHeader("Authorization", token).startRequest();
        if (ConexaoService.isAutorizado(resposta.getStatus())) {
            ConexaoService.checkResponse(resposta, url);
            return resposta;
        }
        ConexaoService.autorizar(config);
        return ConexaoService.verificarPedidos(forcada);
    }

    public static byte[] consultarPedidos(Integer idPedido, Integer idImpressora, String urlPath) throws ConfiguracaoException {
        HTTPURLConnection http = new HTTPURLConnection();
        ConfiguracaoDTO config = ConfigurationService.getConfiguration();
        String url = config.getUrlSoftware() + urlPath;
        RespostaHTTP resposta = http.get(url).addParam("idPedido", idPedido + "").addParam("idImpressora", idImpressora + "").addParam("mobile", "false").addHeader("Authorization", token).startRequestFile();
        if (ConexaoService.isAutorizado(resposta.getStatus())) {
            ConexaoService.checkResponse(resposta, url);
            return resposta.getArquivo();
        }
        ConexaoService.autorizar(config);
        return ConexaoService.consultarPedidos(idPedido, idImpressora, urlPath);
    }
}

