/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.main;

import br.com.argus.cronos.config.ConfigurationService;
import br.com.argus.cronos.exception.ConfiguracaoException;
import br.com.argus.cronos.gui.TipoIconeStatus;
import br.com.argus.cronos.gui.ViewService;
import br.com.argus.cronos.log.LOGService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.service.ImpressaoService;
import br.com.argus.cronos.service.ThreadService;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Main {
    private static ServerSocket socket;

    public static void main(String[] args) {
        ViewService.printResponseArea("Iniciando Sistema.", TipoMensagem.INFO);
        ViewService.setStatus("Iniciando Sistema.", TipoIconeStatus.LOAD);
        Main.verificarApenasUmaAplicacao();
        ImpressaoService.carregarListaImpressoras();
        try {
            ViewService.printResponseArea("Carregando configura\u00e7\u00f5es.", TipoMensagem.INFO);
            ViewService.setStatus("Carregando configura\u00e7\u00f5es.", TipoIconeStatus.LOAD);
            ConfigurationService.preencherInputConfiguracao();
            if (!ConfigurationService.getConfiguration().isIniciarMinimizado()) {
                ViewService.abrirTelaPrincipal();
            }
            ThreadService.iniciarVerificacao();
        }
        catch (ConfiguracaoException e) {
            ViewService.printResponseArea("N\u00e3o foi poss\u00edvel ler as configura\u00e7\u00f5es. Configure o sistema antes do uso.", TipoMensagem.ERROR, e);
            ViewService.setStatus("Falha ao ler configura\u00e7\u00f5es", TipoIconeStatus.STOP);
            ViewService.showTrayMessage("N\u00e3o foi poss\u00edvel ler as configura\u00e7\u00f5es. Configure o sistema antes do uso.", TipoMensagem.ERROR);
        }
    }

    public static void fecharPrograma(boolean pergunta) {
        if (pergunta) {
            int option = JOptionPane.showConfirmDialog(null, "Deseja realmente fechar o auxiliar?", "Confirmar", 0);
            if (option == 0) {
                ViewService.printResponseArea("Fechando Sistema.", TipoMensagem.INFO);
                System.exit(0);
            }
        } else {
            ViewService.printResponseArea("Fechando Sistema.", TipoMensagem.INFO);
            System.exit(0);
        }
    }

    private static void verificarApenasUmaAplicacao() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            socket = new ServerSocket(12345, 1, localAddress);
        }
        catch (Exception e) {
            LOGService.log("O programa j\u00e1 est\u00e1 em execu\u00e7\u00e3o.", TipoMensagem.ERROR, e);
            JOptionPane.showMessageDialog(null, "O programa j\u00e1 est\u00e1 em execu\u00e7\u00e3o.\n Para abri-lo, procure o \u00edcone do auxiliar\n na bandeja do sistema e clique duas vezes, ou ent\u00e3o\n selecione a op\u00e7\u00e3o \"Mostrar Auxiliar\".", "Aviso", 0, new ImageIcon(Main.class.getResource("/exibir-auxiliar.gif")));
            Main.fecharPrograma(false);
        }
    }
}

