/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.gui;

import br.com.argus.cronos.data.DataCalendar;
import br.com.argus.cronos.gui.TelaPrincipal;
import br.com.argus.cronos.gui.TipoIconeStatus;
import br.com.argus.cronos.log.LOGService;
import br.com.argus.cronos.log.TipoMensagem;
import br.com.argus.cronos.main.Main;
import br.com.argus.cronos.service.ThreadService;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ViewService {
    private static final String LOAD_ICON = "/load-1.gif";
    private static final String WAIT_ICON = "/wait-1.gif";
    private static final String STOPED_ICON = "/stoped.png";
    private static final String PLAY_ICON = "/play.png";
    private static final String PAUSE_ICON = "/pause.png";
    private static final String EMPTY_ICON = "/empty.png";
    private static final String PRINTING_ICON = "/printing.png";
    private static MenuItem menuDocumentos;
    private static TelaPrincipal telaPrincipal;

    public static TelaPrincipal getTelaPrincipal() {
        if (telaPrincipal == null) {
            ViewService.setarVisualPadrao();
            ViewService.createSystemTrayIcon();
            telaPrincipal = new TelaPrincipal();
            telaPrincipal.setIconImage(new ImageIcon(TelaPrincipal.class.getResource("/icone-maior.png")).getImage());
        }
        return telaPrincipal;
    }

    private static void setarVisualPadrao() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            JOptionPane.showMessageDialog(null, "Erro ao definir visual!", "Erro!", 0);
        }
    }

    public static void abrirTelaPrincipal() {
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        telaPrincipal.setVisible(true);
    }

    public static void printResponseArea(String texto, TipoMensagem type) {
        ViewService.printResponseArea(texto, type, null);
    }

    public static void printResponseArea(String texto, TipoMensagem type, Throwable cause) {
        DataCalendar data = new DataCalendar();
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        StyledDocument document = telaPrincipal.getTextAreaSaida().getStyledDocument();
        SimpleAttributeSet keyWordColor = new SimpleAttributeSet();
        switch (type) {
            case INFO: {
                StyleConstants.setForeground(keyWordColor, Color.BLUE);
                break;
            }
            case WARNING: {
                StyleConstants.setForeground(keyWordColor, Color.GRAY);
                break;
            }
            case ERROR: {
                StyleConstants.setForeground(keyWordColor, Color.RED);
            }
        }
        StyleConstants.setBold(keyWordColor, true);
        try {
            document.insertString(document.getLength(), data.formatarData(data.getDataSistema(), "dd/MM/yyyy HH:mm:ss") + " : ", null);
            document.insertString(document.getLength(), texto + "\n", keyWordColor);
        }
        catch (BadLocationException ex) {
            LOGService.log("Erro ao inserir texto na \u00e1rea de texto", TipoMensagem.ERROR, ex);
        }
        telaPrincipal.getTextAreaSaida().setCaretPosition(document.getLength());
        LOGService.log(texto, TipoMensagem.INFO, cause);
    }

    public static void setStatus(String message, TipoIconeStatus tipoIcone) {
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        String icone = null;
        switch (tipoIcone) {
            case EMPTY: {
                icone = EMPTY_ICON;
                break;
            }
            case LOAD: {
                icone = LOAD_ICON;
                break;
            }
            case PAUSE: {
                icone = PAUSE_ICON;
                break;
            }
            case PLAY: {
                icone = PLAY_ICON;
                break;
            }
            case STOP: {
                icone = STOPED_ICON;
                break;
            }
            case WAIT: {
                icone = WAIT_ICON;
                break;
            }
            case PRINTING: {
                icone = PRINTING_ICON;
            }
        }
        telaPrincipal.getStatusText().setText(message);
        telaPrincipal.getStatusIcon().setIcon(new ImageIcon(TelaPrincipal.class.getResource(icone)));
    }

    private static void createSystemTrayIcon() {
        if (SystemTray.isSupported()) {
            MouseListener mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        ViewService.abrirTelaPrincipal();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            };
            PopupMenu menu = new PopupMenu();
            MenuItem mostrarAuxiliar = new MenuItem("Mostrar Auxiliar");
            mostrarAuxiliar.addActionListener(e -> ViewService.abrirTelaPrincipal());
            menu.add(mostrarAuxiliar);
            menuDocumentos = new MenuItem("Buscar Documentos");
            menuDocumentos.setEnabled(false);
            menuDocumentos.addActionListener(e -> ThreadService.forcarConsulta(true));
            menu.add(menuDocumentos);
            menu.addSeparator();
            MenuItem quitItem = new MenuItem("Sair");
            quitItem.addActionListener(e -> Main.fecharPrograma(true));
            menu.add(quitItem);
            SystemTray tray = SystemTray.getSystemTray();
            ImageIcon icon = new ImageIcon(SystemTray.class.getResource("/icone.png"));
            Image image = icon.getImage();
            TrayIcon trayIcon = new TrayIcon(image, "Tray Demo", menu);
            trayIcon.setImageAutoSize(true);
            trayIcon.setToolTip("Cronos Auxiliar");
            try {
                tray.add(trayIcon);
            }
            catch (AWTException ex) {
                ViewService.printResponseArea("Erro ao iniciar system tray icon.", TipoMensagem.ERROR, ex);
            }
            trayIcon.addMouseListener(mouseListener);
        }
    }

    public static void showTrayMessage(String text, TipoMensagem type) {
        String title = "Cronos Auxiliar Impressora";
        TrayIcon trayIcon = SystemTray.getSystemTray().getTrayIcons()[0];
        switch (type) {
            case INFO: {
                trayIcon.displayMessage(title, text, TrayIcon.MessageType.INFO);
                break;
            }
            case ERROR: {
                trayIcon.displayMessage(title, text, TrayIcon.MessageType.ERROR);
                break;
            }
            case WARNING: {
                trayIcon.displayMessage(title, text, TrayIcon.MessageType.WARNING);
                break;
            }
            default: {
                throw new IllegalArgumentException("Tipo n\u00e3o informado");
            }
        }
    }

    public static void setBuscarDocumentosEnabled(boolean enabled) {
        TelaPrincipal telaPrincipal = ViewService.getTelaPrincipal();
        telaPrincipal.getConsultIcon().setEnabled(enabled);
        menuDocumentos.setEnabled(enabled);
    }
}

