/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.data;

import br.com.argus.cronos.exception.DataHoraException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public class DataCalendar {
    private final String formatoPadrao = "dd/MM/yyyy";

    public Date getDataSistema() {
        GregorianCalendar calendario = new GregorianCalendar();
        Date dataSistema = calendario.getTime();
        return dataSistema;
    }

    public Date getDataMesFinal(int mes, int ano) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.set(2, mes - 1);
        calendario.set(1, ano);
        calendario.set(5, ((Calendar)calendario).getActualMaximum(5));
        return calendario.getTime();
    }

    public Date getDataMesInicial(int mes, int ano) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.set(2, mes - 1);
        calendario.set(1, ano);
        calendario.set(5, ((Calendar)calendario).getActualMinimum(5));
        return calendario.getTime();
    }

    public Date getDataAnoInicial(int ano) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.set(2, 0);
        calendario.set(1, ano);
        calendario.set(5, ((Calendar)calendario).getActualMinimum(5));
        return calendario.getTime();
    }

    public Date getDataAnoFinal(int ano) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.set(2, 11);
        calendario.set(1, ano);
        calendario.set(5, ((Calendar)calendario).getActualMaximum(5));
        return calendario.getTime();
    }

    public Date getData(int dia, int mes, int ano) {
        GregorianCalendar calendario = new GregorianCalendar();
        calendario.set(2, mes - 1);
        calendario.set(1, ano);
        calendario.set(5, dia);
        return calendario.getTime();
    }

    public int getQuantidadeMesesEntre(Date dataInicio, Date dataFinal) throws IllegalArgumentException {
        if (dataFinal.before(dataInicio)) {
            throw new DataHoraException(this.formatarData(dataInicio, "dd/MM/yyyy"), this.formatarData(dataFinal, "dd/MM/yyyy"));
        }
        GregorianCalendar dInicio = new GregorianCalendar();
        GregorianCalendar dFinal = new GregorianCalendar();
        dInicio.setTime(dataInicio);
        dFinal.setTime(dataFinal);
        int inicio = dInicio.get(1) * 12 + dInicio.get(2);
        int fim = dFinal.get(1) * 12 + dFinal.get(2);
        return fim - inicio;
    }

    public int getQuantidadeDiasEntre(Date dataInicio, Date dataFinal) throws IllegalArgumentException {
        if (dataFinal.before(dataInicio)) {
            throw new DataHoraException(this.formatarData(dataInicio, "dd/MM/yyyy"), this.formatarData(dataFinal, "dd/MM/yyyy"));
        }
        GregorianCalendar dInicio = new GregorianCalendar();
        GregorianCalendar dFinal = new GregorianCalendar();
        dInicio.setTime(dataInicio);
        dFinal.setTime(dataFinal);
        DateTime inicio = new DateTime(dInicio.get(1), dInicio.get(2) + 1, dInicio.get(5), 0, 0);
        DateTime fim = new DateTime(dFinal.get(1), dFinal.get(2) + 1, dFinal.get(5), 0, 0);
        return Days.daysBetween((ReadableInstant)inicio, (ReadableInstant)fim).getDays() + 1;
    }

    public Date diminuirDias(Date data, int dias) {
        GregorianCalendar d = new GregorianCalendar();
        d.setTime(data);
        d.set(5, d.get(5) - dias);
        return d.getTime();
    }

    public List<Date> dividirDiasPeriodo(Date dataInicio, Date dataFinal, int vezes) throws IllegalArgumentException {
        if (this.getQuantidadeDiasEntre(dataInicio, dataFinal) < vezes) {
            throw new IllegalArgumentException("N\u00famero de dias menor que o numero de vezes");
        }
        int diasPeriodo = Math.round(Float.parseFloat(this.getQuantidadeDiasEntre(dataInicio, dataFinal) + "") / Float.parseFloat(vezes + ""));
        ArrayList<Date> datas = new ArrayList<Date>();
        datas.add(dataInicio);
        for (int i = 1; i <= vezes - 2; ++i) {
            datas.add(this.somarDias(dataInicio, diasPeriodo * i));
        }
        datas.add(dataFinal);
        return datas;
    }

    public Date somarDias(Date data, int dias) {
        GregorianCalendar d = new GregorianCalendar();
        d.setTime(data);
        d.set(11, 0);
        d.set(12, 0);
        d.set(13, 0);
        d.set(5, d.get(5) + dias);
        return d.getTime();
    }

    public Date somarMeses(Date data, int meses) {
        GregorianCalendar d = new GregorianCalendar();
        d.setTime(data);
        ((Calendar)d).add(2, meses);
        return d.getTime();
    }

    public String formatarData(Date data, String formato) {
        try {
            SimpleDateFormat f = new SimpleDateFormat(formato);
            return f.format(data);
        }
        catch (IllegalArgumentException e) {
            throw new DataHoraException("Impossivel converter a data.", e);
        }
    }

    public String formatarData(Date data) {
        try {
            SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
            return f.format(data);
        }
        catch (IllegalArgumentException e) {
            throw new DataHoraException("Impossivel converter a data.", e);
        }
    }

    public boolean dataIgual(Date data1, Date data2) {
        return this.formatarData(data2, "yyyy-MM-dd").equals(this.formatarData(data1, "yyyy-MM-dd"));
    }

    public boolean dataHoraIgual(Date data1, Date data2) {
        return this.formatarData(data2, "yyyy-MM-dd HH:mm:ss").equals(this.formatarData(data2, "yyyy-MM-dd HH:mm:ss"));
    }

    public boolean dataEntre(Date data, Date dataInicial, Date dataFinal) {
        GregorianCalendar dataC = new GregorianCalendar();
        dataC.setTime(data);
        dataC.set(11, 0);
        dataC.set(12, 0);
        dataC.set(13, 0);
        GregorianCalendar dataInicialC = new GregorianCalendar();
        dataInicialC.setTime(dataInicial);
        dataInicialC.set(11, 0);
        dataInicialC.set(12, 0);
        dataInicialC.set(13, 0);
        GregorianCalendar dataFinalC = new GregorianCalendar();
        dataFinalC.setTime(dataFinal);
        dataFinalC.set(11, 0);
        dataFinalC.set(12, 0);
        dataFinalC.set(13, 0);
        return this.somarDias(dataC.getTime(), 1).after(dataInicialC.getTime()) && dataC.getTime().before(dataFinalC.getTime());
    }

    public int getMes(Date data) {
        GregorianCalendar dataC = new GregorianCalendar();
        dataC.setTime(data);
        return dataC.get(2) + 1;
    }

    public int getDia(Date data) {
        GregorianCalendar dataC = new GregorianCalendar();
        dataC.setTime(data);
        return dataC.get(5);
    }

    public int getAno(Date data) {
        GregorianCalendar dataC = new GregorianCalendar();
        dataC.setTime(data);
        return dataC.get(1);
    }

    public Date converterStringDate(String data, String formato) {
        SimpleDateFormat f = new SimpleDateFormat(formato);
        try {
            return f.parse(data);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public boolean dataMenor(Date dataReferencia, Date dataVerificar) {
        GregorianCalendar dataV = new GregorianCalendar();
        dataV.setTime(dataVerificar);
        dataV.set(11, 0);
        dataV.set(12, 0);
        dataV.set(13, 0);
        GregorianCalendar dataR = new GregorianCalendar();
        dataR.setTime(dataReferencia);
        dataR.set(11, 0);
        dataR.set(12, 0);
        dataR.set(13, 0);
        return dataV.getTime().before(dataR.getTime());
    }

    public boolean dataHoraMenor(Date dataReferencia, Date dataVerificar) {
        GregorianCalendar dataV = new GregorianCalendar();
        dataV.setTime(dataVerificar);
        GregorianCalendar dataR = new GregorianCalendar();
        dataR.setTime(dataReferencia);
        return dataV.getTime().before(dataR.getTime());
    }

    public Date getData(Date data) {
        GregorianCalendar dataC = new GregorianCalendar();
        dataC.setTime(data);
        dataC.set(11, 0);
        dataC.set(12, 0);
        dataC.set(13, 0);
        return dataC.getTime();
    }

    public boolean dataMaior(Date dataReferencia, Date dataVerificar) {
        GregorianCalendar dataV = new GregorianCalendar();
        dataV.setTime(dataVerificar);
        dataV.set(11, 0);
        dataV.set(12, 0);
        dataV.set(13, 0);
        GregorianCalendar dataR = new GregorianCalendar();
        dataR.setTime(dataReferencia);
        dataR.set(11, 0);
        dataR.set(12, 0);
        dataR.set(13, 0);
        return dataV.getTime().after(dataR.getTime());
    }

    public boolean dataMaiorIgual(Date dataReferencia, Date dataVerificar) {
        GregorianCalendar dataV = new GregorianCalendar();
        dataV.setTime(dataVerificar);
        dataV.set(11, 0);
        dataV.set(12, 0);
        dataV.set(13, 0);
        GregorianCalendar dataR = new GregorianCalendar();
        dataR.setTime(dataReferencia);
        dataR.set(11, 0);
        dataR.set(12, 0);
        dataR.set(13, 0);
        if (this.dataIgual(dataR.getTime(), dataV.getTime())) {
            return true;
        }
        return dataV.getTime().after(dataR.getTime());
    }

    public int getDiaSemana(Date data) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(data);
        return gc.get(7);
    }

    public List<Date> getListaDiasMes(int mes, int ano) {
        ArrayList<Date> listaDatas = new ArrayList<Date>();
        Date diaInicioMes = this.getDataMesInicial(mes, ano);
        Date diaFinalMes = this.getDataMesFinal(mes, ano);
        int intInicio = this.getDia(diaInicioMes);
        int intFinal = this.getDia(diaFinalMes);
        for (int i = intInicio; i <= intFinal; ++i) {
            listaDatas.add(this.getData(i, mes, ano));
        }
        return listaDatas;
    }
}

