/*
 * Decompiled with CFR 0.152.
 */
package br.com.argus.cronos.comunicacao;

import br.com.argus.cronos.comunicacao.RespostaHTTP;
import br.com.argus.cronos.exception.ConnectionException;
import br.com.argus.cronos.exception.PreCondicaoException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HTTPURLConnection {
    private Map parametros;
    private String url;
    private String tipo;
    private boolean postGetChamado;
    private Map headers;
    private String body;
    private byte[] bodyFile;
    private int conectTimeout;
    private int readTimeout;
    private boolean doOutput;
    private String charset;
    private boolean isBodyFile;
    private String attachmentName;
    private String attachmentFileName;
    private final String LINE_FEED = "\r\n";
    private final String twoHyphens = "--";
    private String boundary = "*****";

    private void verificarConfiguracao() {
        if (!this.postGetChamado) {
            throw new PreCondicaoException("O m\u00e9todo get ou post deve ser chamado antes de qualquer configura\u00e7\u00e3o.");
        }
    }

    private void configuracoesIniciais() {
        this.postGetChamado = true;
        this.parametros = new HashMap();
        this.headers = new HashMap();
        this.body = "";
        this.conectTimeout = 15000;
        this.readTimeout = 10000;
        this.doOutput = false;
        this.bodyFile = null;
    }

    public HTTPURLConnection post(String url) {
        this.configuracoesIniciais();
        this.url = url;
        this.tipo = "POST";
        return this;
    }

    public HTTPURLConnection get(String url) {
        this.configuracoesIniciais();
        this.url = url;
        this.tipo = "GET";
        return this;
    }

    public HTTPURLConnection addParam(String nome, String valor) {
        this.verificarConfiguracao();
        this.parametros.put(nome, valor);
        return this;
    }

    public HTTPURLConnection addParam(String nome, Integer valor) {
        this.verificarConfiguracao();
        this.parametros.put(nome, valor);
        return this;
    }

    public HTTPURLConnection addHeader(String nome, String valor) {
        this.verificarConfiguracao();
        this.headers.put(nome, valor);
        return this;
    }

    public HTTPURLConnection addParam(String nome, Float valor) {
        this.verificarConfiguracao();
        this.parametros.put(nome, valor);
        return this;
    }

    public HTTPURLConnection setBody(String body) {
        this.verificarConfiguracao();
        this.body = body;
        return this;
    }

    public HTTPURLConnection setBody(byte[] body, String attachmentName, String attachmentFileName) {
        this.verificarConfiguracao();
        this.attachmentFileName = attachmentFileName;
        this.attachmentName = attachmentName;
        this.bodyFile = body;
        this.isBodyFile = true;
        return this;
    }

    public HTTPURLConnection setDoOutput(boolean doOutput) {
        this.verificarConfiguracao();
        this.doOutput = doOutput;
        return this;
    }

    public RespostaHTTP startRequest() {
        this.verificarConfiguracao();
        this.postGetChamado = false;
        return this.request("normal");
    }

    public RespostaHTTP startRequestFile() {
        this.verificarConfiguracao();
        this.postGetChamado = false;
        return this.request("arquivo");
    }

    private RespostaHTTP request(String opcao) {
        URL URL2 = this.criarUrl(this.url, this.parametros);
        byte[] arquivo = null;
        int responseCode = 0;
        String jsonResponse = "";
        if (URL2 == null) {
            return null;
        }
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        int status = 0;
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        try {
            Throwable throwable;
            urlConnection = (HttpURLConnection)URL2.openConnection();
            if (this.isBodyFile) {
                urlConnection.setUseCaches(false);
                urlConnection.setDoOutput(true);
                urlConnection.setRequestMethod("POST");
                urlConnection.setRequestProperty("Connection", "Keep-Alive");
                urlConnection.setRequestProperty("Cache-Control", "no-cache");
                urlConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + this.boundary);
                urlConnection.setReadTimeout(this.readTimeout);
                urlConnection.setConnectTimeout(this.conectTimeout);
            } else {
                urlConnection.setReadTimeout(this.readTimeout);
                urlConnection.setConnectTimeout(this.conectTimeout);
                urlConnection.setRequestMethod(this.tipo);
                urlConnection.setDoOutput(this.doOutput);
                if (this.tipo.equals("POST")) {
                    urlConnection.setDoOutput(true);
                }
            }
            for (Map.Entry thisEntry : this.headers.entrySet()) {
                String key = (String)thisEntry.getKey();
                String value = (String)thisEntry.getValue();
                urlConnection.setRequestProperty(key, value);
            }
            urlConnection.connect();
            if (this.isBodyFile) {
                this.isBodyFile = false;
                throwable = null;
                try (DataOutputStream request = new DataOutputStream(urlConnection.getOutputStream());){
                    request.writeBytes(this.twoHyphens + this.boundary + this.LINE_FEED);
                    request.writeBytes("Content-Disposition: form-data; name=\"" + this.attachmentName + "\";filename=\"" + this.attachmentFileName + "\"" + this.LINE_FEED);
                    request.writeBytes(this.LINE_FEED);
                    request.write(this.bodyFile);
                    request.writeBytes(this.LINE_FEED);
                    request.writeBytes(this.twoHyphens + this.boundary + this.twoHyphens + this.LINE_FEED);
                    request.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            if (!this.body.equals("")) {
                throwable = null;
                try (OutputStreamWriter wr = new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8");){
                    wr.write(this.body);
                    wr.flush();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Map<String, List<String>> map = urlConnection.getHeaderFields();
            responseHeaders.putAll(this.getResponseHeaders(map));
            responseCode = urlConnection.getResponseCode();
            if (responseCode == 200 || responseCode == 201 || responseCode == 202) {
                if ("arquivo".equals(opcao)) {
                    inputStream = urlConnection.getInputStream();
                    arquivo = IOUtils.toByteArray((InputStream)inputStream);
                } else {
                    inputStream = urlConnection.getInputStream();
                    jsonResponse = this.lerInputStream(inputStream);
                }
            } else {
                inputStream = urlConnection.getErrorStream();
                jsonResponse = this.lerInputStream(inputStream);
            }
            status = urlConnection.getResponseCode();
        }
        catch (IOException ex) {
            throw new ConnectionException("Erro com a conex\u00e3o com o servidor!", ex);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    throw new ConnectionException("Erro com a conex\u00e3o com o servidor!", ex);
                }
            }
        }
        if ("arquivo".equals(opcao) && (responseCode == 200 || responseCode == 201 || responseCode == 202)) {
            return new RespostaHTTP(status, responseHeaders, arquivo);
        }
        return new RespostaHTTP(status, jsonResponse, responseHeaders);
    }

    private URL criarUrl(String stringUrl, Map query) {
        Iterator entries = query.entrySet().iterator();
        StringBuilder s = new StringBuilder(stringUrl);
        s.append("?");
        while (entries.hasNext()) {
            Map.Entry thisEntry = entries.next();
            String key = (String)thisEntry.getKey();
            String value = (String)thisEntry.getValue();
            try {
                s.append(key).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException("Erro ao criar URL.", ex);
            }
        }
        s.delete(s.length() - 1, s.length());
        String URL2 = s.toString();
        try {
            return new URL(URL2);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Erro ao criar URL.", ex);
        }
    }

    private Map<String, List<String>> getResponseHeaders(Map<String, List<String>> responseFields) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        responseFields.entrySet().forEach(entry -> {
            if (entry != null) {
                if ("Content-Type".equals(entry.getKey())) {
                    ((List)entry.getValue()).forEach(string -> {
                        try {
                            this.charset = string.substring(string.indexOf("charset=")).split("=")[1];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                responseHeaders.put((String)entry.getKey(), (List<String>)entry.getValue());
            }
        });
        return responseHeaders;
    }

    private String lerInputStream(InputStream inputStream) {
        StringBuilder output = new StringBuilder();
        if (inputStream != null) {
            try {
                if (this.charset == null) {
                    this.charset = "UTF-8";
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.charset);
                BufferedReader reader = new BufferedReader(inputStreamReader);
                String line = reader.readLine();
                while (line != null) {
                    output.append(line);
                    line = reader.readLine();
                }
            }
            catch (IOException ex) {
                throw new ConnectionException("Erro ao ler resposta do servidor, tente novamente mais tarde.");
            }
        }
        return output.toString();
    }

    public String getBasicAuth(String usuario, String senha) {
        String encoded = Base64.getEncoder().encodeToString((usuario + ":" + senha).getBytes(StandardCharsets.UTF_8));
        return "Basic " + encoded;
    }
}

